<?php if ('layout_four' == $settings['layout_type']) : ?>
	<!--About Four Start-->
	<section class="about-four">
		<div class="container">
			<div class="row">
				<div class="col-xl-6">
					<div class="about-four__left">
						<div class="about-four__img-box">
							<?php if (!empty($settings['layout_four_image']['url'])) : ?>
								<div class="about-four__img">
									<img src="<?php echo esc_url($settings['layout_four_image']['url']); ?>" alt="<?php echo oxpins_get_thumbnail_alt($settings['layout_four_image']['id']); ?>">
								</div>
							<?php endif; ?>
							<?php if (!empty($settings['layout_four_image_two']['url'])) : ?>
								<div class="about-four__img-two">
									<img src="<?php echo esc_url($settings['layout_four_image_two']['url']); ?>" alt="<?php echo oxpins_get_thumbnail_alt($settings['layout_four_image_two']['id']); ?>">
								</div>
							<?php endif; ?>
							<div class="about-four__border"></div>
						</div>
					</div>
				</div>
				<div class="col-xl-6">
					<div class="about-four__right">
						<?php if (!empty($settings['layout_four_sec_title']) || !empty($settings['layout_four_sec_sub_title'])) : ?>
							<div class="section-title text-left">
								<?php if (!empty($settings['layout_four_sec_sub_title'])) : ?>
									<span class="section-title__tagline"><?php echo wp_kses($settings['layout_four_sec_sub_title'], 'oxpins_allowed_tags'); ?></span>
								<?php endif; ?>
								<?php if (!empty($settings['layout_four_sec_title'])) : ?>
									<h2 class="section-title__title"><?php echo wp_kses($settings['layout_four_sec_title'], 'oxpins_allowed_tags'); ?></h2>
								<?php endif; ?>
							</div>
						<?php endif; ?>
						<?php if (!empty($settings['layout_four_summary'])) : ?>
							<p class="about-four__text"><?php echo wp_kses($settings['layout_four_summary'], 'oxpins_allowed_tags'); ?></p>
						<?php endif; ?>
						<?php if (is_array($settings['layout_four_check_list'])) : ?>
							<ul class="list-unstyled about-four__points ml-0">
								<?php foreach ($settings['layout_four_check_list'] as $item) : ?>
									<li>
										<div class="icon">
											<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?>
										</div>
										<div class="text">
											<p><?php echo esc_html($item['title']); ?></p>
										</div>
									</li>
								<?php endforeach; ?>
							</ul>
						<?php endif; ?>
						<?php if (!empty($settings['layout_four_button_label'])) : ?>
							<div class="about-four__btn-box">
								<a <?php echo esc_attr(!empty($settings['layout_four_button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['layout_four_button_url']['url']); ?>" class="thm-btn about-four__btn"><?php echo esc_html($settings['layout_four_button_label']); ?></a>
							</div>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!--About Four End-->
<?php endif; ?>