<?php if ('layout_one' == $settings['layout_type']) : ?>

	<!--About One Start-->
	<section class="about-one">
		<?php if (!empty($settings['shapes'][0]['url'])) : ?>
			<div class="about-one__shape-box-1">
				<div class="about-one__shape-1" style="background-image: url(<?php echo esc_url($settings['shapes'][0]['url']); ?>);"></div>
			</div>
		<?php endif; ?>
		<div class="container">
			<div class="row">
				<div class="col-xl-6">
					<div class="about-one__left">
						<div class="about-one__img-box wow slideInLeft" data-wow-delay="100ms" data-wow-duration="2500ms">
							<?php if (!empty($settings['image']['url'])) : ?>
								<div class="about-one__img">
									<img src="<?php echo esc_url($settings['image']['url']); ?>" alt="<?php echo oxpins_get_thumbnail_alt($settings['image']['id']); ?>">
								</div>
							<?php endif; ?>
							<div class="about-one__img-border"></div>
							<div class="about-one__curved-circle-box">
								<div class="curved-circle">
									<span class="curved-circle--item">
										<?php echo esc_html($settings['image_caption']); ?>
									</span>
								</div><!-- /.curved-circle -->
								<?php if (!empty($settings['caption_image']['url'])) : ?>
									<div class="about-one__curved-circle-icon">
										<img src="<?php echo esc_url($settings['caption_image']['url']); ?>" alt="<?php echo oxpins_get_thumbnail_alt($settings['caption_image']['id']); ?>">
									</div>
								<?php endif; ?>
							</div>
							<?php if (!empty($settings['shapes'][1]['url'])) : ?>
								<div class="about-one__shape-2 zoom-fade">
									<img src="<?php echo esc_url($settings['shapes'][1]['url']); ?>" alt="<?php echo oxpins_get_thumbnail_alt($settings['shapes'][1]['id']); ?>">
								</div>
							<?php endif; ?>
							<?php if (!empty($settings['shapes'][2]['url'])) : ?>
								<div class="about-one__shape-3 float-bob-y">
									<img src="<?php echo esc_url($settings['shapes'][2]['url']); ?>" alt="<?php echo oxpins_get_thumbnail_alt($settings['shapes'][2]['id']); ?>">
								</div>
							<?php endif; ?>
							<?php if (!empty($settings['shapes'][3]['url'])) : ?>
								<div class="about-one__shape-4 zoominout">
									<img src="<?php echo esc_url($settings['shapes'][3]['url']); ?>" alt="<?php echo oxpins_get_thumbnail_alt($settings['shapes'][3]['id']); ?>">
								</div>
							<?php endif; ?>
						</div>
					</div>
				</div>
				<div class="col-xl-6">
					<div class="about-one__right">
						<?php if (!empty($settings['sec_title']) || !empty($settings['sec_sub_title'])) : ?>
							<div class="section-title text-left">
								<?php if (!empty($settings['sec_sub_title'])) : ?>
									<span class="section-title__tagline"><?php echo wp_kses($settings['sec_sub_title'], 'oxpins_allowed_tags'); ?></span>
								<?php endif; ?>
								<?php if (!empty($settings['sec_title'])) : ?>
									<h2 class="section-title__title"><?php echo wp_kses($settings['sec_title'], 'oxpins_allowed_tags'); ?></h2>
								<?php endif; ?>
							</div>
						<?php endif; ?>
						<?php if (!empty($settings['summary'])) : ?>
							<p class="about-one__text"><?php echo wp_kses($settings['summary'], 'oxpins_allowed_tags'); ?></p>
						<?php endif; ?>
						<?php if (!empty($settings['highlighted_text'])) : ?>
							<div class="about-one__fund">
								<p class="about-one__fund-text"><?php echo wp_kses($settings['highlighted_text'], 'oxpins_allowed_tags'); ?>
								</p>
							</div>
						<?php endif; ?>
						<?php if (is_array($settings['layout_one_features_list'])) : ?>
							<ul class="list-unstyled about-one__points ml-0">
								<?php foreach ($settings['layout_one_features_list'] as $box) : ?>
									<li>
										<div class="icon icon-svg">
											<?php \Elementor\Icons_Manager::render_icon($box['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
										</div>
										<div class="text">
											<h5>
												<a <?php echo esc_attr(!empty($box['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($box['url']['url']); ?>"><?php echo esc_html($box['title']); ?></a>
											</h5>
											<p><?php echo esc_html($box['text']); ?></p>
										</div>
									</li>
								<?php endforeach; ?>
							</ul>
						<?php endif; ?>
						<?php if (!empty($settings['button_label'])) : ?>
							<a <?php echo esc_attr(!empty($settings['button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['button_url']['url']); ?>" class="thm-btn about-one__btn"><?php echo esc_html($settings['button_label']); ?></a>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!--About One End-->

<?php endif; ?>