<?php if ('layout_three' == $settings['layout_type']) : ?>
	<!--About Three Start-->
	<section class="about-three">
		<div class="container">
			<div class="row">
				<div class="col-xl-6">
					<div class="about-three__left">
						<?php if (!empty($settings['layout_three_sec_title']) || !empty($settings['layout_three_sec_sub_title'])) : ?>
							<div class="section-title text-left">
								<?php if (!empty($settings['layout_three_sec_sub_title'])) : ?>
									<span class="section-title__tagline"><?php echo wp_kses($settings['layout_three_sec_sub_title'], 'oxpins_allowed_tags'); ?></span>
								<?php endif; ?>
								<?php if (!empty($settings['layout_three_sec_title'])) : ?>
									<h2 class="section-title__title"><?php echo wp_kses($settings['layout_three_sec_title'], 'oxpins_allowed_tags'); ?></h2>
								<?php endif; ?>
							</div>
						<?php endif; ?>
						<?php if (!empty($settings['layout_three_summary'])) : ?>
							<p class="about-three__text-1"><?php echo wp_kses($settings['layout_three_summary'], 'oxpins_allowed_tags'); ?></p>
						<?php endif; ?>
						<?php if (!empty($settings['layout_three_summary_two'])) : ?>
							<p class="about-three__text-2"><?php echo wp_kses($settings['layout_three_summary_two'], 'oxpins_allowed_tags'); ?></p>
						<?php endif; ?>
						<?php if (!empty($settings['layout_three_button_label'])) : ?>
							<a <?php echo esc_attr(!empty($settings['layout_three_button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['layout_three_button_url']['url']); ?>" class="thm-btn about-three__btn"><?php echo esc_html($settings['layout_three_button_label']); ?></a>
						<?php endif; ?>
					</div>
				</div>
				<div class="col-xl-6">
					<div class="about-three__right">
						<div class="about-three__img-box  wow slideInRight" data-wow-delay="100ms" data-wow-duration="2500ms">
							<?php if (!empty($settings['layout_three_image']['url'])) : ?>
								<div class="about-three__img">
									<img src="<?php echo esc_url($settings['layout_three_image']['url']); ?>" alt="<?php echo oxpins_get_thumbnail_alt($settings['layout_three_image']['id']); ?>">
								</div>
							<?php endif; ?>
							<?php if (!empty($settings['layout_three_image_two']['url'])) : ?>
								<div class="about-three__img-two">
									<img src="<?php echo esc_url($settings['layout_three_image_two']['url']); ?>" alt="<?php echo oxpins_get_thumbnail_alt($settings['layout_three_image_two']['id']); ?>">
								</div>
							<?php endif; ?>
							<div class="about-three__help">
								<?php if (!empty($settings['layout_three_caption_image']['url'])) : ?>
									<div class="about-three__help-shape" style="background-image: url(<?php echo esc_url($settings['layout_three_caption_image']['url']); ?>);"></div>
								<?php endif; ?>
								<div class="about-three__help-conten-box">
									<div class="about-three__help-count">
										<h3 class="odometer" data-count="<?php echo esc_attr($settings['layout_three_image_caption_count']); ?>">00</h3>
										<span class="about-three__help-letter"><?php echo esc_html($settings['layout_three_image_count_sign']); ?></span>
									</div>
									<p class="about-three__help-text"><?php echo wp_kses($settings['layout_three_image_caption'], 'oxpins_allowed_tags'); ?></p>
								</div>
							</div>
							<div class="about-three__border"></div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!--About Three End-->
<?php endif; ?>