<?php if ('layout_two' == $settings['layout_type']) : ?>
	<!--About Two Start-->
	<section class="about-two">
		<div class="container">
			<div class="row">
				<div class="col-xl-6">
					<div class="about-two__left">
						<div class="about-two__img-box  wow slideInLeft" data-wow-delay="100ms" data-wow-duration="2500ms">
							<?php if (!empty($settings['layout_two_image_one']['url'])) : ?>
								<div class="about-two__img">
									<img src="<?php echo esc_url($settings['layout_two_image_one']['url']); ?>" alt="<?php echo oxpins_get_thumbnail_alt($settings['layout_two_image_one']['id']); ?>">
								</div>
							<?php endif; ?>
							<?php if (!empty($settings['layout_two_image_two']['url'])) : ?>
								<div class="about-two__img-two">
									<img src="<?php echo esc_url($settings['layout_two_image_two']['url']); ?>" alt="<?php echo oxpins_get_thumbnail_alt($settings['layout_two_image_two']['id']); ?>">
								</div>
							<?php endif; ?>
							<?php if (!empty($settings['layout_two_image_caption'])) : ?>
								<div class="about-two__left-title-box">
									<h3 class="about-two__left-title"><?php echo esc_html($settings['layout_two_image_caption']); ?></h3>
								</div>
							<?php endif; ?>
							<?php if (!empty($settings['layout_two_shape'][0]['url'])) : ?>
								<div class="about-two__shape-1 zoominout">
									<img src="<?php echo esc_url($settings['layout_two_shape'][0]['url']); ?>" alt="<?php echo oxpins_get_thumbnail_alt($settings['layout_two_shape'][0]['id']); ?>">
								</div>
							<?php endif; ?>
							<?php if (!empty($settings['layout_two_shape'][1]['url'])) : ?>
								<div class="about-two__shape-2 rotate-me">
									<img src="<?php echo esc_url($settings['layout_two_shape'][1]['url']); ?>" alt="<?php echo oxpins_get_thumbnail_alt($settings['layout_two_shape'][1]['id']); ?>">
								</div>
							<?php endif; ?>
							<?php if (!empty($settings['layout_two_shape'][2]['url'])) : ?>
								<div class="about-two__shape-3 float-bob-y">
									<img src="<?php echo esc_url($settings['layout_two_shape'][2]['url']); ?>" alt="<?php echo oxpins_get_thumbnail_alt($settings['layout_two_shape'][2]['id']); ?>">
								</div>
							<?php endif; ?>
						</div>
					</div>
				</div>
				<div class="col-xl-6">
					<div class="about-two__right">
						<?php if (!empty($settings['layout_two_sec_title']) || !empty($settings['layout_two_sec_sub_title'])) : ?>
							<div class="section-title text-left">
								<?php if (!empty($settings['layout_two_sec_sub_title'])) : ?>
									<span class="section-title__tagline"><?php echo wp_kses($settings['layout_two_sec_sub_title'], 'oxpins_allowed_tags'); ?></span>
								<?php endif; ?>
								<?php if (!empty($settings['layout_two_sec_title'])) : ?>
									<h2 class="section-title__title"><?php echo wp_kses($settings['layout_two_sec_title'], 'oxpins_allowed_tags'); ?></h2>
								<?php endif; ?>
							</div>
						<?php endif; ?>
						<?php if (!empty($settings['layout_two_summary'])) : ?>
							<p class="about-two__text-1"><?php echo wp_kses($settings['layout_two_summary'], 'oxpins_allowed_tags'); ?></p>
						<?php endif; ?>
						<?php if (is_array($settings['layout_two_features_list'])) : ?>
							<ul class="list-unstyled about-two__points ml-0">
								<?php foreach ($settings['layout_two_features_list'] as $box) : ?>
									<li>
										<div class="icon">
											<?php \Elementor\Icons_Manager::render_icon($box['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
										</div>
										<div class="text">
											<h4><?php echo esc_attr($box['title']); ?></h4>
											<p><?php echo esc_attr($box['text']); ?></p>
										</div>
									</li>
								<?php endforeach; ?>
							</ul>
						<?php endif; ?>
						<?php if (is_array($settings['layout_two_progress_bar'])) : ?>
							<div class="about-two__progress">
								<?php foreach ($settings['layout_two_progress_bar'] as $item) : ?>
									<div class="about-two__progress-single">
										<h4 class="about-two__progress-title"><?php echo esc_html($item['title']); ?></h4>
										<div class="bar">
											<div class="bar-inner count-bar" data-percent="<?php echo esc_attr($item['count']['size']); ?>%">
												<div class="count-text"><?php echo esc_html($item['count']['size']); ?>%</div>
											</div>
										</div>
									</div>
								<?php endforeach; ?>
							</div>
						<?php endif; ?>
						<?php if (!empty($settings['layout_two_button_label'])) : ?>
							<a <?php echo esc_attr(!empty($settings['layout_two_button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['layout_two_button_url']['url']); ?>" class="thm-btn about-two__btn"><?php echo esc_html($settings['layout_two_button_label']); ?></a>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!--About Two End-->
<?php endif; ?>