<?php if ('layout_four' == $settings['layout_type']) : ?>

	<!--News Page Start-->
	<section class="news-page">
		<div class="container">
			<div class="row">
				<?php
				$blog_post_one_query_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
				if (!empty($settings['select_category'])) :
					$blog_post_one_query_args = array(
						'post_type' => 'post',
						'post_status' => 'publish',
						'ignore_sticky_posts' => true,
						'orderby' => 'date',
						'order'   => $settings['query_order'],
						'paged'          => $blog_post_one_query_paged,
						'posts_per_page' => $settings['post_count']['size'],
						'tax_query' => array(
							array(
								'taxonomy' => 'category',
								'field' => 'slug',
								'terms' => $settings['select_category']
							)
						)
					);
				else :
					$blog_post_one_query_args = array(
						'post_type' => 'post',
						'post_status' => 'publish',
						'ignore_sticky_posts' => true,
						'orderby' => 'date',
						'order'   => $settings['query_order'],
						'paged'          => $blog_post_one_query_paged,
						'posts_per_page' => $settings['post_count']['size'],
					);
				endif;
				$blog_post_one_query = new \WP_Query($blog_post_one_query_args);
				?>
				<?php
				while ($blog_post_one_query->have_posts()) :
					$blog_post_one_query->the_post(); ?>
					<!--News One Single Start-->
					<div class="col-xl-4 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay="100ms">
						<div class="news-one__single">
							<?php if (has_post_thumbnail()) : ?>
								<div class="news-one__img">
									<?php the_post_thumbnail('oxpins_blog_370X250'); ?>
								</div>
							<?php endif; ?>
							<div class="news-one__content-box">
								<div class="news-one__content-inner">
									<div class="news-one__content">
										<ul class="list-unstyled news-one__meta ml-0">
											<li><?php oxpins_posted_by(); ?></li>
											<?php if (!is_single() && !post_password_required() && (comments_open() || get_comments_number())) : ?>
												<li><?php oxpins_comment_count(); ?></li>
											<?php endif; ?>
										</ul>
										<h3 class="news-one__title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
									</div>
									<div class="news-one__bottom">
										<div class="news-one__read-more">
											<a href="<?php the_permalink(); ?>"> <span class="icon-right-arrow"></span><?php esc_html_e('Read More', 'oxpins-addon'); ?></a>
										</div>
										<div class="news-one__share">
											<a href="#"><i class="fas fa-share-alt"></i></a>
											<?php do_action('oxpins_social_share'); ?>
										</div>
									</div>
								</div>
								<div class="news-one__date">
									<p><?php the_time('d M, y'); ?></p>
								</div>
							</div>
						</div>
					</div>
					<!--News One Single End-->
				<?php
				endwhile; ?>
				<?php if ('yes' == $settings['pagination_status']) : ?>
					<div class="col-lg-12">
						<div class="blog-pagination portfolio-page__btn-box justify-content-center text-center">
							<?php oxpins_custom_query_pagination($blog_post_one_query_paged, $blog_post_one_query->max_num_pages); ?>
						</div><!-- /.blog-post-pagination -->
					</div><!-- /.col-lg-12 -->
				<?php endif; ?>
				<?php wp_reset_postdata(); ?>

			</div>
		</div>
	</section>
	<!--News Page End-->

<?php endif; ?>