<?php if ('layout_six' == $settings['layout_type']) : ?>
	<section class="blog-page">
		<div class="container">
			<div class="row">
				<?php
				$blog_post_one_query_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
				$blog_post_one_query_args = array(
					'post_type' => 'post',
					'post_status' => 'publish',
					'orderby' => 'date',
					'order'   => $settings['query_order'],
					'ignore_sticky_posts' => true,
					'paged'          => $blog_post_one_query_paged,
					'posts_per_page' => $settings['post_count']['size']
				);
				$blog_post_one_query = new \WP_Query($blog_post_one_query_args);
				?>
				<?php while ($blog_post_one_query->have_posts()) :
					$blog_post_one_query->the_post();
				?>
					<div class="col-sm-12 col-md-6 col-lg-4">
						<!--Blog One single-->
						<div class="blog-one__single">
							<?php if (has_post_thumbnail()) : ?>
								<div class="blog-one__img">
									<?php the_post_thumbnail('oxpins_blog_370X312'); ?>
									<div class="blog-one__date">
										<p><?php the_time('d M'); ?></p>
									</div>
									<a href="<?php the_permalink(); ?>">
										<span class="news-one__plus"></span>
									</a>
								</div>
							<?php endif; ?>
							<div class="blog-one__content">
								<ul class="list-unstyled blog-one__meta ml-0">
									<li><?php oxpins_posted_by(); ?></li>
									<?php if (!is_single() && !post_password_required() && (comments_open() || get_comments_number())) : ?>
										<li><span>/</span></li>
										<li><?php oxpins_comment_count(); ?></li>
									<?php endif; ?>
								</ul>
								<h3 class="blog-one__title">
									<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
								</h3>
								<p class="blog-one__text"><?php echo wp_kses(oxpins_excerpt($settings['post_word_count']['size']), 'oxpins_allowed_tags'); ?></p>
								<div class="blog-one__bottom">
									<a href="<?php the_permalink(); ?>" class="blog-one__btn"><?php esc_html_e('Read More', 'oxpins-addon'); ?></a>
									<a href="<?php the_permalink(); ?>" class="blog-one__arrow"><span class="icon-right-arrow"></span></a>
								</div>
							</div>
						</div>
					</div>
				<?php endwhile; ?>
				<?php if ('yes' == $settings['pagination_status']) : ?>
					<div class="col-lg-12">
						<div class="blog-pagination portfolio-page__btn-box justify-content-center text-center">
							<?php oxpins_custom_query_pagination($blog_post_one_query_paged, $blog_post_one_query->max_num_pages); ?>
						</div><!-- /.blog-post-pagination -->
					</div><!-- /.col-lg-12 -->
				<?php endif; ?>
				<?php wp_reset_postdata(); ?>
			</div><!-- /.thm-owl__carousel -->
		</div>
	</section>
<?php endif; ?>