<?php if ('layout_two' == $settings['layout_type']) : ?>
	<!--News Two Start-->
	<section class="news-two">
		<div class="container">
			<?php if (!empty($settings['title']) || !empty($settings['sub_title'])) : ?>
				<div class="section-title text-center">
					<?php if (!empty($settings['sub_title'])) : ?>
						<span class="section-title__tagline"><?php echo wp_kses($settings['sub_title'], 'oxpins_allowed_tags'); ?></span>
					<?php endif; ?>
					<?php if (!empty($settings['title'])) : ?>
						<h2 class="section-title__title"><?php echo wp_kses($settings['title'], 'oxpins_allowed_tags'); ?></h2>
					<?php endif; ?>
				</div>
			<?php endif; ?>
			<div class="row">
				<?php
				$left_post_query_args = array(
					'post_type' => 'post',
					'p' => $settings['select_post'],
					'posts_per_page' => 1
				);

				$left_post_query = new \WP_Query($left_post_query_args);

				?>
				<?php if ($left_post_query->have_posts()) : ?>
					<?php while ($left_post_query->have_posts()) : ?>
						<?php $left_post_query->the_post(); ?>
						<div class="col-xl-6 col-lg-4">
							<div class="news-two__single">
								<div class="news-two__img-one">
									<?php the_post_thumbnail('oxpins_blog_570X378'); ?>
									<div class="news-two__date-one">
										<p><?php the_time('d M, Y'); ?></p>
									</div>
								</div>
								<div class="news-two__content-one">
									<ul class="list-unstyled news-two__meta-one ml-0">
										<li><?php oxpins_posted_by(); ?></li>
										<?php if (!is_single() && !post_password_required() && (comments_open() || get_comments_number())) : ?>
											<li><?php oxpins_comment_count(); ?></li>
										<?php endif; ?>
									</ul>
									<h3 class="news-two__title-one"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
								</div>
							</div>
						</div>
					<?php endwhile; ?>
				<?php endif; ?>
				<?php wp_reset_postdata(); ?>
				<div class="col-xl-6 col-lg-8">
					<div class="news-two__single">
						<ul class="list-unstyled news-two__list ml-0">
							<?php
							$blog_post_one_query_args = array(
								'post_type' => 'post',
								'post_status' => 'publish',
								'ignore_sticky_posts' => true,
								'orderby' => 'date',
								'order'   => $settings['query_order'],
								'posts_per_page' => $settings['post_count']['size'],
								'post__not_in' => array($settings['select_post'])
							);
							$blog_post_one_query = new \WP_Query($blog_post_one_query_args);
							?>
							<?php while ($blog_post_one_query->have_posts()) :
								$blog_post_one_query->the_post(); ?>
								<li class="news-two__list-single">
									<div class="news-two__img-two">
										<?php the_post_thumbnail('oxpins_blog_268X170'); ?>
										<div class="news-two__date-two">
											<p><?php the_time('d M, Y'); ?></p>
										</div>
									</div>
									<div class="news-two__content-two">
										<ul class="list-unstyled news-two__meta-two ml-0">
											<li><?php oxpins_posted_by(); ?></li>
											<?php if (!is_single() && !post_password_required() && (comments_open() || get_comments_number())) : ?>
												<li><?php oxpins_comment_count(); ?></li>
											<?php endif; ?>
										</ul>
										<h3 class="news-two__title-two"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
									</div>
								</li>
							<?php endwhile; ?>
							<?php wp_reset_postdata(); ?>
						</ul>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!--News Two End-->
<?php endif; ?>