<?php if ('layout_one' === $settings['layout_type']) : ?>

    <!--Become Volunteer Page Start-->
    <section class="become-volunteer-page">
        <div class="container">

            <div class="section-title text-center">
                <?php if (!empty($settings['sec_sub_title'])) : ?>
                    <span class="section-title__tagline"><?php echo wp_kses($settings['sec_sub_title'], 'oxpins_allowed_tags'); ?></span>
                <?php endif; ?>
                <?php if (!empty($settings['sec_title'])) : ?>
                    <h2 class="section-title__title"><?php echo wp_kses($settings['sec_title'], 'oxpins_allowed_tags'); ?></h2>
                <?php endif; ?>
            </div>

            <div class="row">
                <div class="col-xl-6 col-lg-6">
                    <div class="become-volunteer-page__left" style="background-image: url(<?php echo esc_url($settings['left_area_bg']['url']); ?>);">
                        <?php if (!empty($settings['layout_one_image']['url'])) : ?>
                            <div class="become-volunteer-page__img">
                                <img src="<?php echo esc_url($settings['layout_one_image']['url']); ?>" alt="<?php echo esc_attr(oxpins_get_thumbnail_alt($settings['layout_one_image']['id'])); ?>">
                            </div>
                        <?php endif; ?>
                        <div class="become-volunteer-page__content">
                            <?php if (!empty($settings['left_area_title'])) : ?>
                                <h3 class="become-volunteer-page__title"><?php echo wp_kses($settings['left_area_title'], 'oxpins_allowed_tags'); ?></h3>
                            <?php endif; ?>
                            <?php if (!empty($settings['left_area_summary'])) : ?>
                                <p class="become-volunteer-page__text"><?php echo wp_kses($settings['left_area_summary'], 'oxpins_allowed_tags'); ?></p>

                            <?php endif; ?>
                            <?php if (is_array($settings['list_item'])) : ?>
                                <ul class="list-unstyled become-volunteer__points ml-0">
                                    <?php foreach ($settings['list_item'] as $item) : ?>
                                        <li>
                                            <div class="icon icon-svg">
                                                <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?>
                                            </div>
                                            <div class="text">
                                                <p><?php echo esc_html($item['text']); ?></p>
                                            </div>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            <?php endif; ?>
                        </div>
                        <div class="become-volunteer__call">
                            <div class="become-volunteer__call-icon icon-svg">
                                <?php \Elementor\Icons_Manager::render_icon($settings['phone_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
                            </div>
                            <div class="become-volunteer__call-content">
                                <span><?php echo esc_html($settings['call_text']); ?></span>
                                <p><a href="<?php echo esc_url($settings['phone_url']); ?>"><?php echo esc_html($settings['phone_number']); ?></a></p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-6">
                    <div class="become-volunteer-page__right">
                        <?php if (!empty($settings['select_wpcf7_form'])) : ?>
                            <?php echo str_replace("<br />", "", wpautop(trim(do_shortcode('[contact-form-7 id="' . $settings['select_wpcf7_form'] . '" ]')))); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--Become Volunteer Page End-->

<?php endif; ?>