<?php
if ('donor_list' == $settings['layout_type']) :

?>
	<div class="donation-details__recent-donation">
		<?php if (!empty($settings['donation_list_title'])) : ?>
			<h3 class="donation-details__recent-donation-title"><?php echo esc_html($settings['donation_list_title']); ?></h3>
		<?php endif; ?>
		<div class="list-unstyled donation-details__recent-donation-inner">
			<?php if (!empty($settings['donor_list_bg']['url'])) : ?>
				<div class="donation-details__recent-donation-shape" style="background-image: url(<?php echo esc_url($settings['donor_list_bg']['url']); ?>);">
				</div>
			<?php endif; ?>
			<?php if (is_array($settings['donor_list_item'])) : ?>
				<ul class="list-unstyled donation-details__recent-donation-list ml-0">
					<?php foreach ($settings['donor_list_item'] as $item) : ?>
						<li>
							<div class="donation-details__recent-donation-img">
								<img src="<?php echo esc_url($item['donor_image']['url']); ?>" alt="<?php echo esc_attr(oxpins_get_thumbnail_alt($item['donor_image']['id'])); ?>">
							</div>
							<div class="donation-details__recent-donation-content">
								<p><?php echo esc_html($item['name']); ?></p>
								<span><?php echo esc_html($item['amount']); ?></span>
							</div>
						</li>
					<?php endforeach; ?>
				</ul>
			<?php endif; ?>
		</div>
	</div>
<?php endif; ?>