<?php
if ('donate_button' == $settings['layout_type']) :

	$form_id = get_the_ID();
	$form = new Give_Donate_Form($form_id);
	$progress_stats = give_goal_progress_stats($form);
	$income = 0;
	$goal = '';
	$oxpins_give_category =  get_the_terms(get_the_ID(), 'give_forms_category');

	$goal_option = give_get_meta($form_id, '_give_goal_option', true);
	if ($goal_option == 'disabled' || !$goal_option) {
		$goal = 'Unlimited';
		$progress = 100;
		$income = isset($progress_stats['actual']) ? $progress_stats['actual'] : 0;
	}

	if ($goal == 'Unlimited') {
		$progress_label = esc_html__('Unlimited', 'oxpins');
		$progress = 100;
	} else {
		$progress = isset($progress_stats['progress']) ? $progress_stats['progress'] : 100;
		$progress_label = $progress . '%';
		$income = isset($progress_stats['actual']) ? $progress_stats['actual'] : 0;
		$goal = isset($progress_stats['goal']) ? $progress_stats['goal'] : 0;
		if ($progress > 100) $progress = 100;
	}

?>
	<div class="donation-details__donate">
		<?php if (!empty($settings['background_image']['url'])) : ?>
			<div class="donation-details__donate-shape" style="background-image: url(<?php echo esc_url($settings['background_image']['url']); ?>);"></div>
		<?php endif; ?>
		<div class="donation-details__donate-left">
			<ul class="list-unstyled donation-details__donate-list ml-0">
				<li>
					<div class="icon icon-svg">
						<?php \Elementor\Icons_Manager::render_icon($settings['raised_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
					</div>
					<div class="text">
						<span><?php echo esc_html($settings['raised_text']); ?></span>
						<p><?php echo esc_html($income); ?></p>
					</div>
				</li>
				<li>
					<div class="icon icon-svg">
						<?php \Elementor\Icons_Manager::render_icon($settings['goal_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
					</div>
					<div class="text">
						<span><?php echo esc_html($settings['goal_text']); ?></span>
						<p><?php echo esc_html($goal); ?></p>
					</div>
				</li>
			</ul>
		</div>
		<div class="donation-details__donate-btn">
			<?php echo do_shortcode('[give_form id="' . $form_id . '"  display_style="button" show_title="false"  show_goal="false" show_content="none" ]'); ?>
		</div>
	</div>
<?php endif; ?>