<?php if ('layout_one' == $settings['layout_type']) : ?>
	<!--Donate Now Start-->
	<section class="donate-now">
		<div class="container">
			<div class="row">
				<div class="col-xl-8 col-lg-7">
					<div class="donate-now__left">
						<div class="donate-now__enter-donation">
							<?php if (!empty($settings['sec_title'])) : ?>
								<h3 class="donate-now__title"><?php echo wp_kses($settings['sec_title'], 'oxpins_allowed_tags'); ?></h3>
							<?php endif; ?>
							<?php echo do_shortcode('[give_form show_goal="false" show_title="false" show_content="none"   id=' . $settings['select_give_form'] . ']'); ?>
						</div>
					</div>
				</div>
				<?php
				$args = array(
					'post_type' => 'give_forms',
					'post_status' => 'publish',
					'p' => $settings['select_give_form'],
				);
				$my_posts = new WP_Query($args);

				if ($my_posts->have_posts()) :

					while ($my_posts->have_posts()) : $my_posts->the_post();

						$form_id = $settings['select_give_form'];
						$form = new Give_Donate_Form($form_id);
						$progress_stats = give_goal_progress_stats($form);
						$income = 0;
						$goal = '';
						$oxpins_give_category =  get_the_terms(get_the_ID(), 'give_forms_category');

						$goal_option = give_get_meta($form_id, '_give_goal_option', true);
						if ($goal_option == 'disabled' || !$goal_option) {
							$goal = 'Unlimited';
							$progress = 100;
							$income = isset($progress_stats['actual']) ? $progress_stats['actual'] : 0;
						}

						if ($goal == 'Unlimited') {
							$progress_label = esc_html__('Unlimited', 'oxpins');
							$progress = 100;
						} else {
							$progress = isset($progress_stats['progress']) ? $progress_stats['progress'] : 100;
							$progress_label = $progress . '%';
							$income = isset($progress_stats['actual']) ? $progress_stats['actual'] : 0;
							$goal = isset($progress_stats['goal']) ? $progress_stats['goal'] : 0;
							if ($progress > 100) $progress = 100;
						}

						$oxpins_organizer_name = get_post_meta(get_the_ID(), 'oxpins_give_form_organizer_name', true);
						$oxpins_organizer_location = get_post_meta(get_the_ID(), 'oxpins_give_form_organizer_location', true);
						$oxpins_organizer_image = get_post_meta(get_the_ID(), 'oxpins_give_form_organizer_image', true);

				?>
						<div class="col-xl-4 col-lg-5">
							<div class="donate-now__right">
								<div class="causes-one__single">
									<div class="causes-one__img">
										<?php the_post_thumbnail('oxpins_event_370X250'); ?>
										<?php if (!is_wp_error($oxpins_give_category)) : ?>
											<div class="causes-one__cat">
												<p><?php echo esc_html($oxpins_give_category[0]->name); ?></p>
											</div>
										<?php endif; ?>
									</div>
									<div class="causes-one__content">
										<h3 class="causes-one__title">
											<?php the_title(); ?>
										</h3>
										<p class="causes-one__text"><?php echo wp_kses(oxpins_givewp_excerpt($settings['post_word_count']['size']), 'oxpins_allowed_tags'); ?></p>
										<div class="causes-one__progress">
											<?php if (!empty($settings['progress_bar_bg']['url'])) : ?>
												<div class="causes-one__progress-shape" style="background-image: url(<?php echo esc_url($settings['progress_bar_bg']['url']); ?>);"></div>
											<?php endif; ?>
											<div class="bar">
												<div class="bar-inner count-bar" data-percent="<?php echo esc_attr($progress); ?>%">
													<div class="count-text"><?php echo esc_html($progress); ?>%</div>
												</div>
											</div>
											<div class="causes-one__goals">
												<p><span><?php echo esc_html($income); ?></span> <?php echo esc_html__(' Raised', 'oxpins'); ?></p>
												<p><span><?php echo esc_html($goal); ?></span> <?php echo esc_html__(' Goal', 'oxpins'); ?></p>
											</div>
										</div>
									</div>
								</div>
								<?php if (!empty($oxpins_organizer_name || !empty($oxpins_organizer_location) || $oxpins_organizer_image)) : ?>
									<div class="donation-details__organizer">
										<?php if (!empty($settings['organizer_bg']['url'])) : ?>
											<div class="sidebar-shape-1" style="background-image: url(<?php echo esc_url($settings['organizer_bg']['url']); ?>);"></div>
										<?php endif; ?>
										<div class="donation-details__organizer-img">
											<img src="<?php echo esc_url($oxpins_organizer_image); ?>" alt="<?php echo esc_attr(bloginfo('name')); ?>">
										</div>
										<div class="donation-details__organizer-content">
											<p class="donation-details__organizer-date"><?php esc_html_e('Created', 'oxpins-addon'); ?><?php the_time('d M, Y'); ?></p>
											<p class="donation-details__organizer-title"><?php esc_html_e('Organizer', 'oxpins-addon'); ?>:</p>
											<p class="donation-details__organizer-name"><?php echo esc_html($oxpins_organizer_name); ?></p>
											<ul class="list-unstyled donation-details__organizer-list ml-0">
												<?php if (!is_wp_error($oxpins_give_category)) : ?>
													<li>
														<div class="icon">
															<span class="fas fa-tag"></span>
														</div>
														<div class="text">
															<p><?php echo esc_html($oxpins_give_category[0]->name); ?></p>
														</div>
													</li>
												<?php endif; ?>
												<?php if (!empty($oxpins_organizer_location)) : ?>
													<li>
														<div class="icon">
															<span class="fas fa-map-marker-alt"></span>
														</div>
														<div class="text">
															<p><?php echo esc_html($oxpins_organizer_location); ?></p>
														</div>
													</li>
												<?php endif; ?>
											</ul>
										</div>
									</div>
								<?php endif; ?>
							</div>
						</div>
				<?php endwhile;
				endif; ?>
			</div>
		</div>
	</section>
	<!--Donate Now End-->
<?php endif; ?>