<?php
if ('organize' == $settings['layout_type']) :
	$oxpins_organizer_name = get_post_meta(get_the_ID(), 'oxpins_give_form_organizer_name', true);
	$oxpins_organizer_location = get_post_meta(get_the_ID(), 'oxpins_give_form_organizer_location', true);
	$oxpins_organizer_image = get_post_meta(get_the_ID(), 'oxpins_give_form_organizer_image', true);
	$oxpins_give_category =  get_the_terms(get_the_ID(), 'give_forms_category');
?>
	<div class="donation-details__organizer">
		<?php if (!empty($settings['organizer_bg']['url'])) : ?>
			<div class="sidebar-shape-1" style="background-image: url(<?php echo esc_url($settings['organizer_bg']['url']); ?>);"></div>
		<?php endif; ?>
		<?php if (!empty($oxpins_organizer_image)) : ?>
			<div class="donation-details__organizer-img">
				<img src="<?php echo esc_url($oxpins_organizer_image); ?>" alt="<?php echo esc_attr(bloginfo('name')); ?>">
			</div>
		<?php endif; ?>
		<div class="donation-details__organizer-content">
			<p class="donation-details__organizer-date"><?php esc_html_e('Created', 'oxpins-addon'); ?> <?php the_time('d M, Y'); ?></p>
			<p class="donation-details__organizer-title"><?php esc_html_e('Organizer', 'oxpins-addon'); ?>:</p>
			<p class="donation-details__organizer-name"><?php echo esc_html($oxpins_organizer_name); ?></p>
			<ul class="list-unstyled donation-details__organizer-list ml-0">
				<?php if (!is_wp_error($oxpins_give_category) && !empty($oxpins_give_category)) : ?>
					<li>
						<div class="icon">
							<span class="fas fa-tag"></span>
						</div>
						<div class="text">
							<p><?php echo esc_html($oxpins_give_category[0]->name); ?></p>
						</div>
					</li>
				<?php endif; ?>
				<?php if (!empty($oxpins_organizer_location)) : ?>
					<li>
						<div class="icon">
							<span class="fas fa-map-marker-alt"></span>
						</div>
						<div class="text">
							<p><?php echo esc_html($oxpins_organizer_location); ?></p>
						</div>
					</li>
				<?php endif; ?>
			</ul>
		</div>
	</div>
<?php endif; ?>