<?php if ('layout_four' == $settings['layout_type']) : ?>
	<!--Events Page Start-->
	<section class="events-carousel-page">
		<div class="container">
			<div class="events-carousel thm-owl__carousel owl-theme owl-carousel carousel-dot-style" data-owl-options='{
                    "items": 3,
                    "margin": 30,
                    "smartSpeed": 700,
                    "loop":true,
                    "autoplay": 6000,
                    "nav":false,
                    "dots":true,
                    "navText": ["<span class=\"fa fa-angle-left\"></span>","<span class=\"fa fa-angle-right\"></span>"],
                    "responsive":{
                        "0":{
                            "items":1
                        },
                        "768":{
                            "items":2
                        },
                        "992":{
                            "items": 3
                        }
                    }
                }'>
				<?php
				if ($settings['event_type'] == 'upcoming_event') :
					$event_post_query_args = array(
						'post_type' => 'event',
						'order'   => $settings['query_order'],
						'posts_per_page' => $settings['post_count']['size'],
						'meta_key' => 'oxpins_event_date', // required to be used in orderby
						'meta_query' => array(
							array(
								'key' => 'oxpins_event_date',
								'value' => date("Y-m-d"),
								'compare' => '>',
								'type' => 'DATE'
							)
						)
					);
				else :
					$event_post_query_args = array(
						'post_type' => 'event',
						'order'   => $settings['query_order'],
						'orderby' => 'menu_order date',
						'posts_per_page' => $settings['post_count']['size'],
					);
				endif;

				$event_post_query = new \WP_Query($event_post_query_args);
				?>
				<?php if ($event_post_query->have_posts()) : ?>
					<?php while ($event_post_query->have_posts()) : ?>
						<?php $event_post_query->the_post(); ?>
						<?php
						$date = get_post_meta(get_the_ID(), 'oxpins_event_date', true);
						$date = date_create($date);
						?>
						<div class="item">
							<!--Events One Single Start-->
							<div class="events-one__single">
								<div class="events-one__img">
									<?php the_post_thumbnail('oxpins_event_370X470'); ?>
									<div class="events-one__date">
										<p><?php echo date_format($date, "d M, Y"); ?></p>
									</div>
									<div class="events-one__content">
										<ul class="list-unstyled events-one__meta ml-0">
											<?php $oxpins_event_time = get_post_meta(get_the_ID(), 'oxpins_event_starting_time', true); ?>
											<?php if (!empty($oxpins_event_time)) : ?>
												<li><i class="fas fa-clock"></i><?php echo esc_attr($oxpins_event_time); ?></li>
											<?php endif; ?>
											<?php $oxpins_event_country = get_post_meta(get_the_ID(), 'oxpins_event_location', true); ?>
											<?php if (!empty($oxpins_event_country)) : ?>
												<li><i class="fas fa-map-marker-alt"></i><?php echo esc_attr($oxpins_event_country); ?></li>
											<?php endif; ?>
										</ul>
										<h3 class="events-one__title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
									</div>
								</div>
							</div>
							<!--Events One Single End-->
						</div>
					<?php endwhile; ?>
					<?php wp_reset_postdata(); ?>
				<?php endif; ?>
			</div>
		</div>
	</section>
	<!--Events Page End-->
<?php endif; ?>