<?php if ('layout_one' == $settings['layout_type']) : ?>
	<!--Events One Start-->
	<section class="events-one">
		<?php if (!empty($settings['shape']['url'])) : ?>
			<div class="events-one-shape-1" style="background-image: url(<?php echo esc_url($settings['shape']['url']); ?>)"></div>
		<?php endif; ?>
		<div class="container">
			<div class="row">
				<div class="col-xl-4 col-lg-4">
					<div class="events-one__left">
						<?php if (!empty($settings['title']) || !empty($settings['sub_title'])) : ?>
							<div class="section-title text-left">
								<?php if (!empty($settings['sub_title'])) : ?>
									<span class="section-title__tagline"><?php echo wp_kses($settings['sub_title'], 'oxpins_allowed_tags'); ?></span>
								<?php endif; ?>
								<?php if (!empty($settings['title'])) : ?>
									<h2 class="section-title__title"><?php echo wp_kses($settings['title'], 'oxpins_allowed_tags'); ?></h2>
								<?php endif; ?>
							</div>
						<?php endif; ?>
						<?php if (!empty($settings['summary'])) : ?>
							<p class="events-one__text-1"><?php echo wp_kses($settings['summary'], 'oxpins_allowed_tags'); ?></p>
						<?php endif; ?>
						<?php if (!empty($settings['button_label'])) : ?>
							<a <?php echo esc_attr(!empty($settings['button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['button_url']['url']); ?>" class="thm-btn events-one__btn"><?php echo esc_html($settings['button_label']); ?></a>
						<?php endif; ?>
					</div>
				</div>
				<div class="col-xl-8 col-lg-8">
					<div class="events-one__right">
						<div class="events-one__carousel owl-carousel owl-theme thm-owl__carousel" data-owl-options='<?php echo esc_attr(oxpins_get_owl_options($settings)); ?>'>
							<?php
							if ($settings['event_type'] == 'upcoming_event') :
								$event_post_query_args = array(
									'post_type' => 'event',
									'order'   => $settings['query_order'],
									'posts_per_page' => $settings['post_count']['size'],
									'meta_key' => 'oxpins_event_date', // required to be used in orderby
									'meta_query' => array(
										array(
											'key' => 'oxpins_event_date',
											'value' => date("Y-m-d"),
											'compare' => '>',
											'type' => 'DATE'
										)
									)
								);
							else :
								$event_post_query_args = array(
									'post_type' => 'event',
									'order'   => $settings['query_order'],
									'orderby' => 'menu_order date',
									'posts_per_page' => $settings['post_count']['size'],
								);
							endif;

							$event_post_query = new \WP_Query($event_post_query_args);
							?>
							<?php if ($event_post_query->have_posts()) : ?>
								<?php while ($event_post_query->have_posts()) : ?>
									<?php $event_post_query->the_post(); ?>
									<?php
									$date = get_post_meta(get_the_ID(), 'oxpins_event_date', true);
									$date = date_create($date);
									?>
									<div class="item">
										<!--Events One Single Start-->
										<div class="events-one__single">
											<div class="events-one__img">
												<?php if (has_post_thumbnail()) : ?>
													<?php the_post_thumbnail('oxpins_event_270X355'); ?>
												<?php endif; ?>
												<div class="events-one__date">
													<p><?php echo date_format($date, "d M, Y"); ?></p>
												</div>
												<div class="events-one__content">
													<ul class="list-unstyled events-one__meta ml-0">
														<?php $oxpins_event_time = get_post_meta(get_the_ID(), 'oxpins_event_starting_time', true); ?>
														<?php if (!empty($oxpins_event_time)) : ?>
															<li><i class="fas fa-clock"></i><?php echo esc_attr($oxpins_event_time); ?></li>
														<?php endif; ?>
														<?php $oxpins_event_country = get_post_meta(get_the_ID(), 'oxpins_event_location', true); ?>
														<?php if (!empty($oxpins_event_country)) : ?>
															<li><i class="fas fa-map-marker-alt"></i><?php echo esc_attr($oxpins_event_country); ?></li>
														<?php endif; ?>
													</ul>
													<h3 class="events-one__title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
												</div>
											</div>
										</div>
										<!--Events One Single End-->
									</div>
								<?php endwhile; ?>
								<?php wp_reset_postdata(); ?>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!--Events One End-->
<?php endif; ?>