<?php if ('layout_two' == $settings['layout_type']) : ?>
	<!--Events Two Start-->
	<section class="events-two">
		<?php if (!empty($settings['shape']['url'])) : ?>
			<div class="events-two-shape-1" style="background-image: url(<?php echo esc_url($settings['shape']['url']) ?>);"></div>
		<?php endif; ?>
		<?php if (!empty($settings['bg_image']['url'])) : ?>
			<div class="events-two-bg" style="background-image: url(<?php echo esc_url($settings['bg_image']['url']) ?>);"></div>
		<?php endif; ?>
		<div class="container">
			<div class="row">
				<div class="col-xl-6 col-lg-6">
					<div class="events-two__left">
						<div class="section-title text-left">
							<?php if (!empty($settings['sub_title'])) : ?>
								<span class="section-title__tagline"><?php echo wp_kses($settings['sub_title'], 'oxpins_allowed_tags'); ?></span>
							<?php endif; ?>
							<?php if (!empty($settings['title'])) : ?>
								<h2 class="section-title__title"><?php echo wp_kses($settings['title'], 'oxpins_allowed_tags'); ?></h2>
							<?php endif; ?>
						</div>
						<?php if (!empty($settings['summary'])) : ?>
							<p class="events-two__text"><?php echo wp_kses($settings['summary'], 'oxpins_allowed_tags'); ?>
							</p>
						<?php endif; ?>
						<?php if (!empty($settings['button_label'])) : ?>
							<a <?php echo esc_attr(!empty($settings['button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['button_url']['url']); ?>" class="thm-btn events-two__btn"><?php echo esc_html($settings['button_label']); ?></a>
						<?php endif; ?>
					</div>
				</div>
				<div class="col-xl-6 col-lg-6">
					<div class="events-two__right">
						<?php if (!empty($settings['shape_two']['url'])) : ?>
							<div class="events-two__right-bg-box">
								<div class="events-two-shape-2" style="background-image: url(<?php echo esc_url($settings['shape_two']['url']) ?>);"></div>
							</div>
						<?php endif; ?>
						<ul class="list-unstyled events-two__list ml-0">
							<?php
							if ($settings['event_type'] == 'upcoming_event') :
								$event_post_query_args = array(
									'post_type' => 'event',
									'order'   => $settings['query_order'],
									'posts_per_page' => $settings['post_count']['size'],
									'meta_key' => 'oxpins_event_date', // required to be used in orderby
									'meta_query' => array(
										array(
											'key' => 'oxpins_event_date',
											'value' => date("Y-m-d"),
											'compare' => '>',
											'type' => 'DATE'
										)
									)
								);
							else :
								$event_post_query_args = array(
									'post_type' => 'event',
									'order'   => $settings['query_order'],
									'orderby' => 'menu_order date',
									'posts_per_page' => $settings['post_count']['size'],
								);
							endif;

							$event_post_query = new \WP_Query($event_post_query_args);
							?>
							<?php if ($event_post_query->have_posts()) : ?>
								<?php while ($event_post_query->have_posts()) : ?>
									<?php $event_post_query->the_post(); ?>
									<?php
									$date = get_post_meta(get_the_ID(), 'oxpins_event_date', true);
									$date = date_create($date);
									?>
									<li>
										<?php if (has_post_thumbnail()) : ?>
											<div class="events-two__img">
												<?php the_post_thumbnail('oxpins_event_240X184'); ?>
												<div class="events-two__date">
													<p><?php the_time('d M, Y'); ?></p>
												</div>
											</div>
										<?php endif; ?>
										<div class="events-two__content">
											<ul class="list-unstyled events-two__meta ml-0">
												<?php $oxpins_event_time = get_post_meta(get_the_ID(), 'oxpins_event_starting_time', true); ?>
												<?php if (!empty($oxpins_event_time)) : ?>
													<li><i class="fas fa-clock"></i><?php echo esc_attr($oxpins_event_time); ?></li>
												<?php endif; ?>
												<?php $oxpins_event_country = get_post_meta(get_the_ID(), 'oxpins_event_country', true); ?>
												<?php if (!empty($oxpins_event_country)) : ?>
													<li><i class="fas fa-map-marker-alt"></i><?php echo esc_attr($oxpins_event_country); ?></li>
												<?php endif; ?>
											</ul>
											<h3 class="events-two__title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
											<div class="events-two__read-more">
												<a href="<?php the_permalink(); ?>"> <span class="icon-right-arrow"></span><?php esc_html_e('Read More', 'oxpins-addon'); ?></a>
											</div>
										</div>
									</li>
								<?php endwhile; ?>
								<?php wp_reset_postdata(); ?>
							<?php endif; ?>
						</ul>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!--Events Two End-->
<?php endif; ?>