<?php if ('layout_one' == $settings['layout_type']) : ?>
    <!--Feature One Start-->
    <section class="feature-one">
        <div class="container">
            <div class="row">
                <?php
                $i = 1;
                foreach ($settings['fancy_box_items'] as $item) : ?>
                    <div class="col-xl-6 col-lg-6  wow  <?php echo esc_attr(1 == $i ? 'slideInLeft' : 'slideInRight'); ?>" data-wow-delay="100ms" data-wow-duration="2500ms">
                        <div class="feature-one__single  <?php echo esc_attr(2 == $i ? 'feature-one__single--two' : ''); ?>">
                            <?php if (!empty($item['background']['url'])) : ?>
                                <div class="feature-one__single-bg" style="background-image: url(<?php echo esc_url($item['background']['url']); ?>);"></div>
                            <?php endif; ?>
                            <div class="feature-one__top">
                                <div class="feature-one__top-inner">
                                    <div class="feature-one__top-icon icon-svg-large <?php echo esc_attr(2 == $i ? 'feature-one__top-icon--two' : ''); ?>">
                                        <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
                                    </div>
                                    <div class="feature-one__top-title-box">
                                        <h3 class="feature-one__top-title"><a <?php echo esc_attr(!empty($item['button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['button_url']['url']); ?>"><?php echo wp_kses($item['title'], 'oxpins_allowed_tags'); ?></a></h3>
                                    </div>
                                </div>
                            </div>
                            <p class="feature-one__text"><?php echo wp_kses($item['summary'], 'oxpins_allowed_tags'); ?></p>
                            <ul class="list-unstyled feature-one__point ml-0">
                                <?php echo wp_kses($item['list'], 'oxpins_allowed_tags'); ?>
                            </ul>
                            <a <?php echo esc_attr(!empty($item['button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['button_url']['url']); ?>" class="thm-btn feature-one__btn"><?php echo esc_html($item['button_label']); ?></a>
                        </div>
                    </div>
                <?php $i++;
                endforeach; ?>
            </div>
        </div>
    </section>
    <!--Feature One End-->
<?php endif; ?>