<?php if ('layout_three' == $settings['layout_type']) : ?>
    <!--Feature Three Start-->
    <section class="feature-three">
        <div class="container">
            <div class="row">
                <?php
                foreach ($settings['fancy_box_three_items'] as $item) : ?>
                    <div class="col-xl-4 col-lg-12">
                        <div class="feature-three__single">
                            <div class="feature-three__img" style="background-image: url(<?php echo esc_url($item['image']['url']); ?>);"></div>
                            <div class="feature-three__title-box">
                                <h3 class="feature-three__title"><?php echo esc_html($item['title']); ?></h3>
                            </div>
                            <div class="feature-three__btn">
                                <a <?php echo esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>"><?php echo esc_html($item['read_more_text']); ?></a>
                            </div>
                        </div>
                    </div>
                <?php
                endforeach; ?>
            </div>
        </div>
    </section>
    <!--Feature Three End-->
<?php endif; ?>