<?php if ('layout_two' == $settings['layout_type']) : ?>
    <!--Feature Two Start-->
    <section class="feature-two">
        <div class="container">
            <div class="row">
                <?php
                $i = 1;
                foreach ($settings['fancy_box_two_items'] as $item) : ?>
                    <!--Feature Two Single Start-->
                    <div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="<?php echo esc_attr($i); ?>00ms">
                        <div class="feature-two__single">
                            <div class="feature-two__single-inner">
                                <?php if (!empty($item['background']['url'])) : ?>
                                    <div class="feature-two-shape-1" style="background-image: url(<?php echo esc_url($item['background']['url']); ?>);"></div>
                                <?php endif; ?>
                                <div class="feature-two__content-box">
                                    <div class="feature-two__content-left">
                                        <p class="feature-two__tagline"><?php echo wp_kses($item['sub_title'], 'oxpins_allowed_tags'); ?></p>
                                        <h3 class="feature-two__title"><a <?php echo esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>"><?php echo wp_kses($item['title'], 'oxpins_allowed_tags'); ?></a></h3>
                                    </div>
                                    <div class="feature-two__icon">
                                        <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
                                    </div>
                                </div>
                            </div>
                            <div class="feature-two__arrow">
                                <a <?php echo esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>"><span class="icon-right-arrow"></span></a>
                            </div>
                        </div>
                    </div>
                    <!--Feature Two Single End-->
                <?php $i++;
                endforeach; ?>
            </div>
        </div>
    </section>
    <!--Feature Two End-->
<?php endif; ?>