<?php if ('layout_two' == $settings['layout_type']) : ?>
	<!--FAQ One Start-->
	<section class="faq-one faq-two">
		<?php if (!empty($settings['bg_shape']['url'])) : ?>
			<div class="faq-one-shape-1" style="background-image: url(<?php echo esc_url($settings['bg_shape']['url']); ?>);"></div>
		<?php endif; ?>
		<?php if (!empty($settings['bg_image']['url'])) : ?>
			<div class="faq-one-bg" style="background-image: url(<?php echo esc_url($settings['bg_image']['url']); ?>);"></div>
		<?php endif; ?>
		<div class="container">
			<div class="row">
				<div class="col-xl-6 col-lg-6">
					<div class="faq-one__left">
						<?php if (!empty($settings['sec_title']) || !empty($settings['sec_sub_title'])) : ?>
							<div class="section-title text-left">
								<?php if (!empty($settings['sec_sub_title'])) : ?>
									<span class="section-title__tagline"><?php echo wp_kses($settings['sec_sub_title'], 'oxpins_allowed_tags'); ?></span>
								<?php endif; ?>
								<?php if (!empty($settings['sec_title'])) : ?>
									<h2 class="section-title__title"><?php echo wp_kses($settings['sec_title'], 'oxpins_allowed_tags'); ?></h2>
								<?php endif; ?>
							</div>
						<?php endif; ?>
						<?php if (!empty($settings['summary'])) : ?>
							<p class="faq-one__text-1"><?php echo wp_kses($settings['summary'], 'oxpins_allowed_tags'); ?></p>
						<?php endif; ?>
						<?php if (!empty($settings['button_label'])) : ?>
							<a <?php echo esc_attr(!empty($settings['button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['button_url']['url']); ?>" class="thm-btn faq-one__btn"><?php echo esc_html($settings['button_label']); ?></a>
						<?php endif; ?>
					</div>
				</div>
				<div class="col-xl-6 col-lg-6">
					<div class="faq-one__right">
						<div class="accrodion-grp faq-one-accrodion" data-grp-name="faq-one-accrodion-<?php echo esc_attr(uniqid()); ?>">
							<?php
							foreach ($settings['faq_lists'] as $list) :
							?>
								<div class="accrodion <?php echo esc_attr(('yes' == $list['active_status'] ? 'active' : '')); ?>">
									<div class="accrodion-title">
										<h4><?php echo wp_kses($list['question'], 'oxpins_allowed_tags'); ?></h4>
									</div>
									<div class="accrodion-content">
										<div class="inner">
											<p><?php echo wp_kses($list['answer'], 'oxpins_allowed_tags'); ?></p>
										</div><!-- /.inner -->
									</div>
								</div>
							<?php
							endforeach; ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!--FAQ One End-->
<?php endif; ?>