<?php if ('layout_one' == $settings['layout_type']) : ?>
	<div class="footer-widget__column footer-widget__about">
		<div class="footer-widget__about-logo">
			<a href="<?php echo esc_url(home_url('/')); ?>"><img width="<?php echo esc_attr($settings['logo_dimension']['width']); ?>" height="<?php echo esc_attr($settings['logo_dimension']['height']); ?>" src="<?php echo esc_attr($settings['logo']['url']); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>"></a>
		</div>
		<div class="footer-widget__about-text-box">
			<p class="footer-widget__about-text"><?php echo wp_kses($settings['text'], 'oxpins_allowed_tags'); ?></p>
		</div>
		<?php if (!empty($settings['button_label'])) : ?>
			<div class="footer-widget__btn">
				<a <?php echo esc_attr(!empty($settings['button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['button_url']['url']); ?>"> <span class="fa fa-heart"></span>
					<?php echo esc_html($settings['button_label']); ?>
				</a>
			</div>
		<?php endif; ?>
	</div>
<?php endif; ?>