<?php if ('layout_one' == $settings['layout_type']) : ?>
	<div class="footer-widget__column footer-widget__contact">
		<?php if (!empty($settings['title'])) : ?>
			<h3 class="footer-widget__title"><?php echo esc_html($settings['title']); ?></h3>
		<?php endif; ?>
		<?php if (!empty($settings['about_text'])) : ?>
			<p class="footer-widget__contact-text"><?php echo wp_kses($settings['about_text'], 'oxpins_allowed_tags'); ?>
			</p>
		<?php endif; ?>

		<ul class="list-unstyled footer-widget__contact-list ml-0">
			<?php foreach ($settings['items'] as $item) : ?>
				<li>
					<div class="icon">
						<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?>
					</div>
					<div class="text">
						<p>
							<?php echo wp_kses($item['content'], 'oxpins_allowed_tags'); ?>
						</p>
					</div>
				</li>
			<?php endforeach; ?>
		</ul>
		<?php if (is_array($settings['social_icons'])) : ?>
			<div class="site-footer__social ml-0">
				<?php foreach ($settings['social_icons'] as $item) : ?>
					<a href="<?php echo esc_url($item['social_url']['url']); ?>">
						<?php \Elementor\Icons_Manager::render_icon($item['social_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?>
					</a>
				<?php endforeach; ?>
			</div>
		<?php endif; ?>
	</div>
<?php endif; ?>