<?php if ('layout_one' == $settings['layout_type']) : ?>
    <!--Gallery One Start-->
    <section class="gallery-one">
        <?php if (!empty($settings['sec_title'])) : ?>
            <div class="gallery-one__top">
                <h3 class="gallery-one__top-title"><?php echo esc_html($settings['sec_title']); ?></h3>
            </div>
        <?php endif; ?>
        <div class="gallery-one__bottom">
            <div class="gallery-one__container">
                <ul class="list-unstyled gallery-one__list">
                    <?php if (is_array($settings['gallery_images'])) : ?>
                        <?php $i = 1;
                        foreach ($settings['gallery_images'] as $image) : ?>
                            <li class="gallery-one__single wow fadeInUp" data-wow-delay="<?php echo esc_attr($i); ?>00ms">
                                <div class="gallery-one__img">
                                    <img src="<?php echo esc_url($image['image']['url']); ?>" alt="<?php echo esc_attr(oxpins_get_thumbnail_alt($image['image']['id'])); ?>">
                                    <a href="<?php echo esc_url($image['image']['url']); ?>" class="img-popup"></a>
                                    <div class="gallery-one__content">
                                        <!-- /.img-popup -->
                                        <p class="gallery-one__sub-title"><?php echo esc_html($image['sub_title']); ?></p>
                                        <h5 class="gallery-one__title"><?php echo esc_html($image['title']); ?></h5>
                                    </div>
                                </div>
                            </li>
                        <?php $i++;
                        endforeach; ?>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </section>
    <!--Gallery One End-->
<?php endif; ?>