<?php if ('layout_three' == $settings['layout_type']) : ?>

    <!--Gallery Page Start-->
    <section class="gallery-page">
        <div class="container">
            <div class="row">
                <?php if (is_array($settings['gallery_images'])) : ?>
                    <?php foreach ($settings['gallery_images'] as $image) : ?>
                        <!--Gallery Page Single Start-->
                        <div class="col-xl-4 col-lg-6 col-md-6">
                            <div class="gallery-page__single">
                                <div class="gallery-page__img">
                                    <img src="<?php echo esc_url($image['image']['url']); ?>" alt="<?php echo esc_attr(oxpins_get_thumbnail_alt($image['image']['id'])); ?>">
                                    <a href="<?php echo esc_url($image['image']['url']); ?>" class="img-popup"></a>
                                    <!-- /.img-popup -->
                                    <div class="gallery-page__content">
                                        <p class="gallery-page__sub-title"><?php echo esc_html($image['sub_title']); ?></p>
                                        <h5 class="gallery-page__title"><?php echo esc_html($image['title']); ?></h5>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--Gallery Page Single End-->
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </section>
    <!--Gallery Page End-->
<?php endif; ?>