<?php if ('layout_four' == $settings['layout_type']) : ?>
    <?php
    $give_form_post_query_args = array(
        'post_type' => 'give_forms',
        'p' => $settings['select_give_form'],
        'posts_per_page' => 1
    );

    $give_form_post_query = new \WP_Query($give_form_post_query_args);

    ?>
    <?php if ($give_form_post_query->have_posts()) : ?>
        <?php while ($give_form_post_query->have_posts()) : ?>
            <?php $give_form_post_query->the_post(); ?>
            <?php
            $form_id = get_the_ID();
            $form = new Give_Donate_Form($form_id);
            $progress_stats = give_goal_progress_stats($form);
            $income = 0;
            $goal = '';

            $goal_option = give_get_meta($form_id, '_give_goal_option', true);
            if ($goal_option == 'disabled' || !$goal_option) {
                $goal = 'Unlimited';
                $progress = 100;
                $income = isset($progress_stats['actual']) ? $progress_stats['actual'] : 0;
            }

            if ($goal == 'Unlimited') {
                $progress_label = esc_html__('Unlimited', 'oxpins');
                $progress = 100;
            } else {
                $progress = isset($progress_stats['progress']) ? $progress_stats['progress'] : 100;
                $progress_label = $progress . '%';
                $income = isset($progress_stats['actual']) ? $progress_stats['actual'] : 0;
                $goal = isset($progress_stats['goal']) ? $progress_stats['goal'] : 0;
                if ($progress > 100) $progress = 100;
            }

            ?>
            <!--Make Donation Start-->
            <section class="make-donation">
                <div class="container">
                    <div class="make-donation__inner">
                        <div class="row">
                            <div class="col-xl-4 col-lg-6">
                                <div class="make-donation__left">
                                    <?php if (!empty($settings['layout_four_image']['url'])) : ?>
                                        <div class="make-donation__img">
                                            <img src="<?php echo esc_url($settings['layout_four_image']['url']); ?>" alt="<?php echo esc_attr(oxpins_get_thumbnail_alt($settings['layout_four_image']['id'])); ?>">
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="col-xl-8 col-lg-6">
                                <div class="make-donation__right">
                                    <div class="make-donation__content">
                                        <div class="make-donation__btn-box">
                                            <a href="<?php the_permalink(); ?>" class="thm-btn make-donation__btn"><?php echo esc_html($settings['btn_label']); ?></a>
                                        </div>
                                        <?php if (is_array($settings['layout_two_info_box_items'])) : ?>
                                            <ul class="list-unstyled make-donation__meta ml-0">
                                                <?php foreach ($settings['layout_two_info_box_items'] as $item) : ?>
                                                    <li>
                                                        <a <?php echo esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>">
                                                            <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?> <?php echo esc_html($item['content']); ?>
                                                        </a>
                                                    </li>
                                                <?php endforeach; ?>
                                            </ul>
                                        <?php endif; ?>
                                        <?php if (!empty($settings['title'])) : ?>
                                            <h3 class="make-donation__title"><?php echo wp_kses($settings['title'], 'oxpins_allowed_tags'); ?></h3>
                                        <?php endif; ?>
                                        <?php if (!empty($settings['sub_title'])) : ?>
                                            <p class="make-donation__text"><?php echo wp_kses($settings['sub_title'], 'oxpins_allowed_tags'); ?></p>
                                        <?php endif; ?>
                                        <ul class="list-unstyled make-donation__raised-goal ml-0">
                                            <li>
                                                <div class="icon">
                                                    <?php \Elementor\Icons_Manager::render_icon($settings['raised_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?>
                                                </div>
                                                <div class="content">
                                                    <p><?php echo esc_html__(' Raised', 'oxpins'); ?></p>
                                                    <h4><?php echo esc_html($income); ?></h4>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="icon">
                                                    <i class="dolar-icon-style"><?php echo esc_html($settings['currency_type']); ?></i>
                                                </div>
                                                <div class="content">
                                                    <p><?php echo esc_html__(' Goal', 'oxpins'); ?></p>
                                                    <h4><?php echo esc_html($goal); ?></h4>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!--Make Donation End-->
        <?php
        endwhile; ?>
    <?php endif; ?>
    <?php wp_reset_postdata(); ?>
<?php endif; ?>