<?php if ('layout_one' == $settings['layout_type']) : ?>
	<!--Causes One Start-->
	<section class="causes-one">
		<div class="container">
			<?php if (!empty($settings['title']) || !empty($settings['sub_title'])) : ?>
				<div class="section-title text-center">
					<?php if (!empty($settings['sub_title'])) : ?>
						<span class="section-title__tagline"><?php echo wp_kses($settings['sub_title'], 'oxpins_allowed_tags'); ?></span>
					<?php endif; ?>
					<?php if (!empty($settings['title'])) : ?>
						<h2 class="section-title__title"><?php echo wp_kses($settings['title'], 'oxpins_allowed_tags'); ?></h2>
					<?php endif; ?>
				</div>
			<?php endif; ?>
			<div class="row">
				<?php
				$give_form_post_query_args = array(
					'post_type' => 'give_forms',
					'orderby' => 'menu_order date',
					'order'   => $settings['query_order'],
					'posts_per_page' => $settings['post_count']['size']
				);

				$give_form_post_query = new \WP_Query($give_form_post_query_args);

				$i = 1;

				?>
				<?php if ($give_form_post_query->have_posts()) : ?>
					<?php while ($give_form_post_query->have_posts()) : ?>
						<?php $give_form_post_query->the_post(); ?>
						<?php $category =  get_the_terms(get_the_ID(), 'give_forms_category'); ?>
						<?php
						$form_id = get_the_ID();
						$form = new Give_Donate_Form($form_id);
						$progress_stats = give_goal_progress_stats($form);
						$income = 0;
						$goal = '';

						$goal_option = give_get_meta($form_id, '_give_goal_option', true);
						if ($goal_option == 'disabled' || !$goal_option) {
							$goal = 'Unlimited';
							$progress = 100;
							$income = isset($progress_stats['actual']) ? $progress_stats['actual'] : 0;
						}

						if ($goal == 'Unlimited') {
							$progress_label = esc_html__('Unlimited', 'oxpins');
							$progress = 100;
						} else {
							$progress = isset($progress_stats['progress']) ? $progress_stats['progress'] : 100;
							$progress_label = $progress . '%';
							$income = isset($progress_stats['actual']) ? $progress_stats['actual'] : 0;
							$goal = isset($progress_stats['goal']) ? $progress_stats['goal'] : 0;
							if ($progress > 100) $progress = 100;
						}
						?>
						<!--Causes One Single Start-->
						<div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="<?php echo esc_attr($i); ?>00ms">
							<div class="causes-one__single">
								<?php if (has_post_thumbnail()) : ?>
									<div class="causes-one__img">
										<?php the_post_thumbnail('oxpins_give_form_370X250'); ?>
										<?php if (!empty($category[0]->name)) : ?>
											<div class="causes-one__cat">
												<p><?php echo esc_html($category[0]->name); ?></p>
											</div>
										<?php endif; ?>
									</div>
								<?php endif; ?>
								<div class="causes-one__content">
									<h3 class="causes-one__title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
									</h3>
									<p class="causes-one__text"><?php echo wp_kses(oxpins_givewp_excerpt($settings['post_word_count']['size']), 'oxpins_allowed_tags'); ?></p>
									<div class="causes-one__progress">
										<?php if (!empty($settings['progress_bar_bg']['url'])) : ?>
											<div class="causes-one__progress-shape" style="background-image: url(<?php echo esc_url($settings['progress_bar_bg']['url']); ?>);"></div>
										<?php endif; ?>
										<div class="bar">
											<div class="bar-inner count-bar" data-percent="<?php echo esc_attr($progress); ?>%">
												<div class="count-text"><?php echo esc_attr($progress); ?>%</div>
											</div>
										</div>
										<div class="causes-one__goals">
											<p><span><?php echo esc_html($income); ?></span> <?php echo esc_html__(' Raised', 'oxpins'); ?></p>
											<p><span><?php echo esc_html($goal); ?></span> <?php echo esc_html__(' Goal', 'oxpins'); ?></p>
										</div>
									</div>
								</div>
							</div>
						</div>
						<!--Causes One Single End-->
					<?php $i++;
					endwhile; ?>
				<?php endif; ?>
				<?php wp_reset_postdata(); ?>
			</div>
		</div>
	</section>
	<!--Causes One End-->
<?php endif; ?>