<?php if ('layout_seven' == $settings['layout_type']) : ?>

    <!--Donations List Start-->
    <section class="donations-list">
        <div class="container">
            <div class="donations-list__inner">
                <?php
                $give_forms_post_query_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
                $give_form_post_query_args = array(
                    'post_type' => 'give_forms',
                    'paged'          => $give_forms_post_query_paged,
                    'orderby' => 'menu_order date',
                    'order'   => $settings['query_order'],
                    'posts_per_page' => $settings['post_count']['size']
                );

                $give_form_post_query = new \WP_Query($give_form_post_query_args);

                $i = 1;

                ?>
                <?php if ($give_form_post_query->have_posts()) : ?>
                    <?php while ($give_form_post_query->have_posts()) : ?>
                        <?php $give_form_post_query->the_post(); ?>
                        <?php $category =  get_the_terms(get_the_ID(), 'give_forms_category'); ?>
                        <?php
                        $form_id = get_the_ID();
                        $form = new Give_Donate_Form($form_id);
                        $progress_stats = give_goal_progress_stats($form);
                        $income = 0;
                        $goal = '';

                        $goal_option = give_get_meta($form_id, '_give_goal_option', true);
                        if ($goal_option == 'disabled' || !$goal_option) {
                            $goal = 'Unlimited';
                            $progress = 100;
                            $income = isset($progress_stats['actual']) ? $progress_stats['actual'] : 0;
                        }

                        if ($goal == 'Unlimited') {
                            $progress_label = esc_html__('Unlimited', 'oxpins');
                            $progress = 100;
                        } else {
                            $progress = isset($progress_stats['progress']) ? $progress_stats['progress'] : 100;
                            $progress_label = $progress . '%';
                            $income = isset($progress_stats['actual']) ? $progress_stats['actual'] : 0;
                            $goal = isset($progress_stats['goal']) ? $progress_stats['goal'] : 0;
                            if ($progress > 100) $progress = 100;
                        }
                        ?>
                        <!--Donations List Single Start-->
                        <div class="donations-list__single">
                            <div class="row">
                                <div class="col-xl-6 col-lg-6">
                                    <?php if (has_post_thumbnail()) : ?>
                                        <div class="donations-list__img">
                                            <?php the_post_thumbnail('oxpins_give_form_585X467'); ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="col-xl-6 col-lg-6">
                                    <div class="donations-list__right">
                                        <div class="donations-list__content">
                                            <?php if (!empty($category[0]->name)) : ?>
                                                <div class="donations-list__category">
                                                    <p><?php echo esc_html($category[0]->name); ?></p>
                                                </div>
                                            <?php endif; ?>
                                            <h3 class="donations-list__title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                            <p class="donations-list__text"><?php echo wp_kses(oxpins_givewp_excerpt($settings['post_word_count']['size']), 'oxpins_allowed_tags'); ?></p>
                                            <div class="donations-list__progress">
                                                <?php if (!empty($settings['progress_bar_bg']['url'])) : ?>
                                                    <div class="donations-list__progress-shape" style="background-image: url(<?php echo esc_url($settings['progress_bar_bg']['url']); ?>);">
                                                    </div>
                                                <?php endif; ?>
                                                <div class="bar">
                                                    <div class="bar-inner count-bar" data-percent="<?php echo esc_attr($progress); ?>%">
                                                        <div class="count-text"><?php echo esc_html($progress); ?>%</div>
                                                    </div>
                                                </div>
                                                <div class="causes-one__goals">
                                                    <p><span><?php echo esc_html($income); ?></span> <?php echo esc_html__(' Raised', 'oxpins-addon'); ?></p>
                                                    <p><span><?php echo esc_html($goal); ?></span> <?php echo esc_html__(' Goal', 'oxpins-addon'); ?></p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--Donations List Single End-->
                    <?php $i++;
                    endwhile; ?>
                    <?php if ('yes' == $settings['pagination_status']) : ?>
                        <div class="col-lg-12">
                            <div class="blog-post-pagination">
                                <?php oxpins_custom_query_pagination($give_forms_post_query_paged, $give_form_post_query->max_num_pages); ?>
                            </div><!-- /.blog-post-pagination -->
                        </div><!-- /.col-lg-12 -->
                    <?php endif; ?>
                    <?php wp_reset_postdata(); ?>
                <?php endif; ?>
            </div>
        </div>
    </section>
    <!--Donations List End-->

<?php endif; ?>