<?php

use PHP_CodeSniffer\Reports\Emacs;

if ('layout_three' == $settings['layout_type']) : ?>
	<?php
	$give_form_post_query_args = array(
		'post_type' => 'give_forms',
		'p' => $settings['select_give_form'],
		'posts_per_page' => 1
	);

	$give_form_post_query = new \WP_Query($give_form_post_query_args);

	?>
	<?php if ($give_form_post_query->have_posts()) : ?>
		<?php while ($give_form_post_query->have_posts()) : ?>
			<?php $give_form_post_query->the_post(); ?>
			<?php
			$form_id = get_the_ID();
			$form = new Give_Donate_Form($form_id);
			$progress_stats = give_goal_progress_stats($form);
			$income = 0;
			$goal = '';

			$goal_option = give_get_meta($form_id, '_give_goal_option', true);
			if ($goal_option == 'disabled' || !$goal_option) {
				$goal = 'Unlimited';
				$progress = 100;
				$income = isset($progress_stats['actual']) ? $progress_stats['actual'] : 0;
			}

			if ($goal == 'Unlimited') {
				$progress_label = esc_html__('Unlimited', 'oxpins');
				$progress = 100;
			} else {
				$progress = isset($progress_stats['progress']) ? $progress_stats['progress'] : 100;
				$progress_label = $progress . '%';
				$income = isset($progress_stats['actual']) ? $progress_stats['actual'] : 0;
				$goal = isset($progress_stats['goal']) ? $progress_stats['goal'] : 0;
				if ($progress > 100) $progress = 100;
			}

			?>
			<!--Urgent Cause Start-->
			<section class="urgent-cause">
				<div class="container">
					<div class="urgent-cause__inner wow fadeInUp" data-wow-delay="100ms">
						<?php if (!empty($settings['bg_image']['url'])) : ?>
							<div class="urgent-cause-bg" style="background-image: url(<?php echo esc_url($settings['bg_image']['url']); ?>);"></div>
						<?php endif; ?>
						<div class="urgent-cause__top">
							<div class="urgent-cause__top-left">
								<div class="section-title text-left">
									<?php if (!empty($settings['sub_title'])) : ?>
										<span class="section-title__tagline"><?php echo wp_kses($settings['sub_title'], 'oxpins_allowed_tags'); ?></span>
									<?php endif; ?>
									<?php if (!empty($settings['title'])) : ?>
										<h2 class="section-title__title"><?php echo wp_kses($settings['title'], 'oxpins_allowed_tags'); ?></h2>
									<?php endif; ?>
								</div>
							</div>
							<div class="urgent-cause__top-right">
								<?php if (!empty($settings['summary'])) : ?>
									<p class="urgent-cause__top-text"><?php echo wp_kses($settings['summary'], 'oxpins_allowed_tags'); ?></p>
								<?php endif; ?>
								<?php if (!empty($settings['btn_label'])) :  ?>
									<div class="urgent-cause__btn">
										<a href="<?php the_permalink(); ?>">
											<?php \Elementor\Icons_Manager::render_icon($settings['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
											<?php echo esc_html($settings['btn_label']); ?>
										</a>
									</div>
								<?php endif; ?>
								<p class="urgent-cause__date"><?php the_time('d M Y'); ?></p>
							</div>
						</div>
						<div class="urgent-cause__progress">
							<div class="bar">
								<div class="bar-inner count-bar" data-percent="<?php echo esc_attr($progress); ?>%">
									<div class="count-text"><?php echo esc_html($progress); ?>%</div>
								</div>
							</div>
							<div class="urgent-cause__goals">
								<p><span><?php echo esc_html($income); ?></span> <?php echo esc_html__(' Donated', 'oxpins'); ?></p>
								<p><span><?php echo esc_html($goal); ?></span> <?php echo esc_html__(' Goal', 'oxpins'); ?></p>
							</div>
						</div>
					</div>
				</div>
			</section>
			<!--Urgent Cause End-->
		<?php
		endwhile; ?>
	<?php endif; ?>
	<?php wp_reset_postdata(); ?>
<?php endif; ?>