<?php
if ('layout_two' == $settings['layout_type']) :
	$give_form_category = $settings['select_category'];
?>
	<!--Causse Two Start-->
	<section class="causes-two">
		<?php if (!empty($settings['bg_shape']['url'])) : ?>
			<div class="causes-two-shape-1" style="background-image: url(<?php echo esc_url($settings['bg_shape']['url']); ?>);"></div>
		<?php endif; ?>
		<div class="container">
			<div class="causes-two__top">
				<div class="row">
					<div class="col-xl-7 col-lg-6">
						<div class="causes-two-top__left">
							<div class="section-title text-left">
								<?php if (!empty($settings['sub_title'])) : ?>
									<span class="section-title__tagline"><?php echo wp_kses($settings['sub_title'], 'oxpins_allowed_tags'); ?></span>
								<?php endif; ?>
								<?php if (!empty($settings['title'])) : ?>
									<h2 class="section-title__title"><?php echo wp_kses($settings['title'], 'oxpins_allowed_tags'); ?></h2>
								<?php endif; ?>
							</div>
						</div>
					</div>
					<?php if (!empty($settings['summary'])) : ?>
						<div class="col-xl-5 col-lg-6">
							<div class="causes-two-top__right">
								<p class="causes-two-top__text"><?php echo wp_kses($settings['summary'], 'oxpins_allowed_tags'); ?></p>
							</div>
						</div>
					<?php endif; ?>
				</div>
			</div>
			<div class="causes-two__tab">
				<div class="causes-two__tab-box tabs-box">
					<div class="row">
						<?php if (!empty($give_form_category) && !is_wp_error($give_form_category)) : ?>
							<div class="col-xl-3 col-lg-3">
								<div class="causes-two__tab-btn-box">
									<ul class="tab-buttons clearfix list-unstyled ml-0">

										<li data-tab="#all-causes" class="tab-btn active-btn"><span><?php esc_html_e('All causes', 'oxpins-addon'); ?>
												<sup><?php echo esc_html($settings['post_count']['size']); ?></sup> </span>
										</li>
										<?php
										foreach ($give_form_category as $category) :
											$cat = get_term_by('slug', $category, 'give_forms_category');
											$cat_slug = $cat->slug;

										?>
											<li data-tab="#<?php echo esc_attr($cat_slug); ?>" class="tab-btn"><span><?php echo esc_html($cat->name); ?> <sup><?php echo esc_html($cat->count); ?></sup></span></li>
										<?php endforeach; ?>
									</ul>
								</div>
							</div>
						<?php endif; ?>
						<div class="col-xl-9 col-lg-9">
							<div class="causes-two__tab-main-content">
								<div class="tabs-content">
									<?php if (!empty($give_form_category) && !is_wp_error($give_form_category)) : ?>
										<?php
										$i = 1;

										array_unshift($give_form_category, 'all-causes');

										foreach ($give_form_category as $category) :
											$cat = get_term_by('slug', $category, 'give_forms_category');
											if ($i != 1) {
												$cat_slug = $cat->slug;
											}

										?>
											<!--tab-->
											<div class="tab <?php echo esc_attr(($i == 1 ? 'active-tab' : '')); ?>" id="<?php echo esc_attr(($i == 1 ? 'all-causes'  : $cat_slug)); ?>">
												<div class="causes-two__inner-content">
													<div class="causes-two__carousel owl-carousel owl-theme thm-owl__carousel" data-owl-options='{
                                                    "loop": true,
                                                    "autoplay": true,
                                                    "margin": 30,
                                                    "nav": true,
                                                    "dots": false,
                                                    "smartSpeed": 500,
                                                    "autoplayTimeout": 10000,
                                                    "navText": ["<span class=\"fa fa-angle-left\"><p>Previous</p></span>",
                                                    "<span class=\"fa fa-angle-right\"><p>Next</p></span>"],
                                                    "responsive": {
                                                        "0": {
                                                            "items": 1
                                                        },
                                                        "768": {
                                                            "items": 1
                                                        },
                                                        "992": {
                                                            "items": 3
                                                        },
                                                        "1200": {
                                                            "items": 3.181111
                                                        }
                                                    }
                                                }'>
														<?php
														if ($i == 1) :
															$give_form_post_query_args = array(
																'post_type' => 'give_forms',
																'orderby' => 'menu_order date',
																'order'   => $settings['query_order'],
																'posts_per_page' => $settings['post_count']['size'],
															);
														else :
															$give_form_post_query_args = array(
																'post_type' => 'give_forms',
																'orderby' => 'menu_order date',
																'order'   => $settings['query_order'],
																'posts_per_page' => $settings['post_count']['size'],
																'tax_query' => array(
																	array(
																		'taxonomy' => 'give_forms_category',
																		'field' => 'slug',
																		'terms' => esc_attr($cat_slug)
																	)
																)
															);
														endif;

														$give_form_post_query = new \WP_Query($give_form_post_query_args);

														?>
														<?php if ($give_form_post_query->have_posts()) : ?>
															<?php while ($give_form_post_query->have_posts()) : ?>
																<?php $give_form_post_query->the_post(); ?>
																<?php $category =  get_the_terms(get_the_ID(), 'give_forms_category'); ?>
																<?php
																$form_id = get_the_ID();
																$form = new Give_Donate_Form($form_id);
																$progress_stats = give_goal_progress_stats($form);
																$income = 0;
																$goal = '';

																$goal_option = give_get_meta($form_id, '_give_goal_option', true);
																if ($goal_option == 'disabled' || !$goal_option) {
																	$goal = 'Unlimited';
																	$progress = 100;
																	$income = isset($progress_stats['actual']) ? $progress_stats['actual'] : 0;
																}

																if ($goal == 'Unlimited') {
																	$progress_label = esc_html__('Unlimited', 'oxpins');
																	$progress = 100;
																} else {
																	$progress = isset($progress_stats['progress']) ? $progress_stats['progress'] : 100;
																	$progress_label = $progress . '%';
																	$income = isset($progress_stats['actual']) ? $progress_stats['actual'] : 0;
																	$goal = isset($progress_stats['goal']) ? $progress_stats['goal'] : 0;
																	if ($progress > 100) $progress = 100;
																}
																?>
																<div class="item">
																	<div class="causes-one__single">
																		<?php if (has_post_thumbnail()) : ?>
																			<div class="causes-one__img">
																				<?php the_post_thumbnail('oxpins_give_form_370X250'); ?>
																				<?php if (!empty($category[0]->name)) : ?>
																					<div class="causes-one__cat">
																						<p><?php echo esc_html($category[0]->name); ?></p>
																					</div>
																				<?php endif; ?>
																			</div>
																		<?php endif; ?>
																		<div class="causes-one__content">
																			<h3 class="causes-one__title">
																				<a href="<?php the_permalink(); ?>">
																					<?php the_title(); ?>
																				</a>
																			</h3>
																			<p class="causes-one__text"><?php echo wp_kses(oxpins_givewp_excerpt($settings['post_word_count']['size']), 'oxpins_allowed_tags'); ?></p>
																			<div class="causes-one__progress">
																				<?php if (!empty($settings['progress_bar_bg']['url'])) : ?>
																					<div class="causes-one__progress-shape" style="background-image: url(<?php echo esc_url($settings['progress_bar_bg']['url']); ?>);">
																					</div>
																				<?php endif; ?>
																				<div class="bar">
																					<div class="bar-inner count-bar" data-percent="<?php echo esc_attr($progress); ?>%">
																						<div class="count-text"><?php echo esc_html($progress); ?>%</div>
																					</div>
																				</div>
																				<div class="causes-one__goals">
																					<p><span><?php echo esc_html($income); ?></span> <?php echo esc_html__(' Raised', 'oxpins'); ?></p>
																					<p><span><?php echo esc_html($goal); ?></span> <?php echo esc_html__(' Goal', 'oxpins'); ?></p>
																				</div>
																			</div>
																		</div>
																	</div>
																</div>

															<?php
															endwhile; ?>
														<?php endif; ?>
														<?php wp_reset_postdata(); ?>
													</div>
												</div>
											</div>
											<!--tab-->
										<?php $i++;
										endforeach; ?>
									<?php else : ?>
										<h2><?php esc_html_e('Please Select Category To Display Post', 'oxpins-addon'); ?></h2>
									<?php endif; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!--Causse Two End-->
<?php endif; ?>