<?php $search_status = $settings['search_status']; ?>
<?php $cart_status = $settings['cart_status']; ?>
<?php $login_status = $settings['login']; ?>
<?php $one_page_class = 'yes' == $settings['one_page_status'] ? 'one-page-scroll-menu' : ' '; ?>
<?php if ('layout_one' === $settings['layout_type']) : ?>

	<header class="main-header">
		<nav class="main-menu">
			<div class="main-menu__wrapper">
				<div class="main-menu__wrapper-inner">
					<div class="main-menu__left">
						<div class="main-menu__logo">
							<a href="<?php echo esc_url(home_url('/')); ?>"><img width="<?php echo esc_attr($settings['logo_dimension']['width']); ?>" height="<?php echo esc_attr($settings['logo_dimension']['height']); ?>" src="<?php echo esc_attr($settings['dark_logo']['url']); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>"></a>
						</div>
						<?php if (!empty($settings['logo_shape']['url'])) : ?>
							<div class="main-menu__shape-1 float-bob-x">
								<img src="<?php echo esc_url($settings['logo_shape']['url']); ?>" alt="<?php echo esc_attr(oxpins_get_thumbnail_alt($settings['logo_shape']['id'])); ?>">
							</div>
						<?php endif; ?>
					</div>
					<div class="main-menu__right">
						<div class="main-menu__right-top">
							<div class="main-menu__right-top-left">
								<div class="main-menu__volunteers">
									<?php if (!empty($settings['top_bar_left_content_icon']['url'])) : ?>
										<div class="main-menu__volunteers-icon">
											<a href="<?php echo esc_url($settings['top_bar_left_content_url']['url']); ?>"><img src="<?php echo esc_url($settings['top_bar_left_content_icon']['url']); ?>" alt="<?php echo esc_attr($settings['top_bar_left_content_icon']['id']); ?>"></a>
										</div>
									<?php endif; ?>
									<?php if (!empty($settings['top_bar_left_content'])) : ?>
										<div class="main-menu__volunteers-text-box">
											<p class="main-menu__volunteers-text"><a href="<?php echo esc_url($settings['top_bar_left_content_url']['url']); ?>"><?php echo wp_kses($settings['top_bar_left_content'], 'oxpins_allowed_tags'); ?></a></p>
										</div>
									<?php endif; ?>
								</div>
							</div>
							<div class="main-menu__right-top-right">
								<?php if (is_array($settings['top_bar_right_content'])) : ?>
									<div class="main-menu__right-top-address">
										<ul class="list-unstyled main-menu__right-top-address-list ml-0">
											<?php foreach ($settings['top_bar_right_content'] as $item) : ?>
												<li>
													<div class="icon icon-svg">
														<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
													</div>
													<div class="content">
														<p><?php echo esc_html($item['title']); ?></p>
														<h5><?php echo wp_kses($item['content'], 'oxpins_allowed_tags'); ?></h5>
													</div>
												</li>
											<?php endforeach; ?>
										</ul>
									</div>
								<?php endif; ?>
								<?php if (is_array($settings['social_icons'])) : ?>
									<div class="main-menu__right-top-social">
										<?php foreach ($settings['social_icons'] as $item) : ?>
											<a class="icons-svg" href="<?php echo esc_url($item['social_url']['url']);  ?>">
												<?php \Elementor\Icons_Manager::render_icon($item['social_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?>
											</a>
										<?php endforeach; ?>
									</div>
								<?php endif; ?>
							</div>
						</div>
						<div class="main-menu__right-bottom">
							<div class="main-menu__main-menu-box">
								<a href="#" class="mobile-nav__toggler"><i class="fa fa-bars"></i></a>
								<?php
								wp_nav_menu(
									array(
										'menu' => $settings['nav_menu'],
										'menu_class' => 'main-menu__list ' . $one_page_class,
										'walker'         => class_exists('\Layerdrops\Oxpins\Megamenu\Walker_Nav_Menu') ? new \Layerdrops\Oxpins\Megamenu\Walker_Nav_Menu : '',
									)
								);
								?>
							</div>
							<div class="main-menu__main-menu-content-box">
								<div class="main-menu__search-cat-btn-box">
									<?php if (('yes' == $search_status)) : ?>
										<div class="main-menu__search-box">
											<a href="#" class="main-menu__search search-toggler icon-magnifying-glass"></a>
										</div>
									<?php endif; ?>
									<?php if (('yes' == $login_status)) : ?>
										<div class="main-menu__cat-box">
											<a href="<?php echo esc_url($settings['login_url']['url']); ?>" class="main-menu__cart icon-avatar"></a>
										</div>
									<?php endif; ?>
									<?php if (('yes' == $cart_status) && class_exists('WooCommerce')) : ?>
										<div class="main-menu__cat-box">
											<a href="<?php echo esc_url(wc_get_cart_url()); ?>" class="main-menu__cart icon-shopping-cart"></a>
										</div>
									<?php endif; ?>
									<?php if (!empty($settings['btn_text'])) : ?>
										<div class="main-menu__btn-box">
											<a <?php echo esc_attr(!empty($settings['btn_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['btn_url']['url']); ?>" class="main-menu__btn"> <span class="fa fa-heart"></span>
												<?php echo esc_html($settings['btn_text']); ?>
											</a>
										</div>
									<?php endif; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</nav>
	</header>

	<?php if (get_theme_mod('header_sticky_menu') == 'yes' && !is_admin_bar_showing()) : ?>
		<div class="stricky-header stricked-menu main-menu">
			<div class="sticky-header__content"></div><!-- /.sticky-header__content -->
		</div><!-- /.stricky-header -->
	<?php endif; ?>

<?php endif; ?>


<?php if ('layout_two' === $settings['layout_type']) : ?>
	<header class="main-header-two">
		<nav class="main-menu main-menu-two">
			<div class="main-menu-two__wrapper">
				<div class="main-menu-two__wrapper-inner">
					<div class="main-menu-two__left">

						<div class="main-menu-two__logo">
							<a href="<?php echo esc_url(home_url('/')); ?>"><img width="<?php echo esc_attr($settings['logo_dimension']['width']); ?>" height="<?php echo esc_attr($settings['logo_dimension']['height']); ?>" src="<?php echo esc_attr($settings['light_logo']['url']); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>"></a>
						</div>
						<?php if (!empty($settings['logo_shape']['url'])) : ?>
							<div class="main-menu-two__shape-1 float-bob-x">
								<img src="<?php echo esc_url($settings['logo_shape']['url']); ?>" alt="<?php echo esc_attr($settings['logo_shape']['id']); ?>">
							</div>
						<?php endif; ?>
					</div>
					<div class="main-menu-two__right">
						<div class="main-menu-two__right-top">
							<div class="main-menu-two__right-top-left">
								<div class="main-menu-two__volunteers">
									<?php if (!empty($settings['top_bar_left_content_icon']['url'])) : ?>
										<div class="main-menu-two__volunteers-icon">
											<a href="<?php echo esc_url($settings['top_bar_left_content_url']['url']); ?>"><img src="<?php echo esc_url($settings['top_bar_left_content_icon']['url']); ?>" alt="<?php echo esc_attr($settings['top_bar_left_content_icon']['id']); ?>"></a>
										</div>
									<?php endif; ?>
									<?php if (!empty($settings['top_bar_left_content'])) : ?>
										<div class="main-menu-two__volunteers-text-box">
											<p class="main-menu-two__volunteers-text">
												<a href="<?php echo esc_url($settings['top_bar_left_content_url']['url']); ?>">
													<?php echo wp_kses($settings['top_bar_left_content'], 'oxpins_allowed_tags'); ?>
												</a>
											</p>
										</div>
									<?php endif; ?>
								</div>
							</div>
							<div class="main-menu-two__right-top-right">
								<div class="main-menu-two__right-top-address">
									<ul class="list-unstyled main-menu-two__right-top-address-list ml-0">
										<?php foreach ($settings['top_bar_right_content'] as $item) : ?>
											<li>
												<div class="icon icon-svg">
													<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
												</div>
												<div class="content">
													<p><?php echo esc_html($item['title']); ?></p>
													<h5><?php echo wp_kses($item['content'], 'oxpins_allowed_tags'); ?></h5>
												</div>
											</li>
										<?php endforeach; ?>
									</ul>
								</div>
							</div>
						</div>
						<div class="main-menu-two__right-bottom">
							<div class="main-menu-two__main-menu-box">
								<a href="#" class="mobile-nav__toggler"><i class="fa fa-bars"></i></a>
								<?php
								wp_nav_menu(
									array(
										'menu' => $settings['nav_menu'],
										'menu_class' => 'main-menu__list ' . $one_page_class,
										'walker'         => class_exists('\Layerdrops\Oxpins\Megamenu\Walker_Nav_Menu') ? new \Layerdrops\Oxpins\Megamenu\Walker_Nav_Menu : '',
									)
								);
								?>
							</div>
							<div class="main-menu-two__main-menu-content-box">
								<div class="main-menu-two__search-cat-btn-box">
									<?php if (('yes' == $search_status)) : ?>
										<div class="main-menu-two__search-box">
											<a href="#" class="main-menu-two__search search-toggler icon-magnifying-glass"></a>
										</div>
									<?php endif; ?>
									<?php if (('yes' == $login_status)) : ?>
										<div class="main-menu-two__cat-box">
											<a href="<?php echo esc_url($settings['login_url']['url']); ?>" class="main-menu-two__cart icon-avatar"></a>
										</div>
									<?php endif; ?>
									<?php if (('yes' == $cart_status) && class_exists('WooCommerce')) : ?>
										<div class="main-menu-two__cat-box">
											<a href="<?php echo esc_url(wc_get_cart_url()); ?>" class="main-menu-two__cart icon-shopping-cart"></a>
										</div>
									<?php endif; ?>
									<?php if (!empty($settings['btn_text'])) : ?>
										<div class="main-menu-two__btn-box">
											<a <?php echo esc_attr(!empty($settings['btn_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['btn_url']['url']); ?>" class="main-menu-two__btn"> <span class="fa fa-heart"></span>
												<?php echo esc_html($settings['btn_text']); ?>
											</a>
										</div>
									<?php endif; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</nav>
	</header>

	<?php if (get_theme_mod('header_sticky_menu') == 'yes' && !is_admin_bar_showing()) : ?>
		<div class="stricky-header stricked-menu main-menu main-menu-two">
			<div class="sticky-header__content"></div><!-- /.sticky-header__content -->
		</div><!-- /.stricky-header -->
	<?php endif; ?>
<?php endif; ?>

<?php if ('layout_three' === $settings['layout_type']) : ?>

	<header class="main-header-three">
		<nav class="main-menu main-menu-three">
			<div class="main-menu-three__wrapper">
				<div class="main-menu-three__wrapper-inner">
					<div class="main-menu-three__left">
						<div class="main-menu-three__logo">
							<a href="<?php echo esc_url(home_url('/')); ?>"><img width="<?php echo esc_attr($settings['logo_dimension']['width']); ?>" height="<?php echo esc_attr($settings['logo_dimension']['height']); ?>" src="<?php echo esc_attr($settings['light_logo']['url']); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>"></a>
						</div>
					</div>
					<div class="main-menu-three__right">
						<div class="main-menu-three__right-inner">
							<div class="main-menu-three__right-content-box">
								<div class="main-menu-three__right-top">
									<div class="main-menu-three__volunteers">
										<?php if (!empty($settings['top_bar_left_content_icon']['url'])) : ?>
											<div class="main-menu-three__volunteers-icon">
												<a href="<?php echo esc_url($settings['top_bar_left_content_url']['url']); ?>"><img src="<?php echo esc_url($settings['top_bar_left_content_icon']['url']); ?>" alt="<?php echo esc_attr($settings['top_bar_left_content_icon']['id']); ?>"></a>
											</div>
										<?php endif; ?>
										<?php if (!empty($settings['top_bar_left_content'])) : ?>
											<div class="main-menu-three__volunteers-text-box">
												<p class="main-menu-three__volunteers-text">
													<a href="<?php echo esc_url($settings['top_bar_left_content_url']['url']); ?>">
														<?php echo wp_kses($settings['top_bar_left_content'], 'oxpins_allowed_tags'); ?>
													</a>
												</p>
											</div>
										<?php endif; ?>
									</div>
									<div class="main-menu-three__call">
										<div class="main-menu-three__icon icon-svg">
											<?php \Elementor\Icons_Manager::render_icon($settings['call_Icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?>
										</div>
										<div class="main-menu-three__number">
											<a href="<?php echo esc_url($settings['call_url']); ?>"><?php echo esc_html($settings['call_number']); ?></a>
										</div>
									</div>
								</div>
								<div class="main-menu-three__right-bottom">
									<div class="main-menu-three__main-menu-box">
										<a href="#" class="mobile-nav__toggler"><i class="fa fa-bars"></i></a>
										<?php
										wp_nav_menu(
											array(
												'menu' => $settings['nav_menu'],
												'menu_class' => 'main-menu__list ' . $one_page_class,
												'walker'         => class_exists('\Layerdrops\Oxpins\Megamenu\Walker_Nav_Menu') ? new \Layerdrops\Oxpins\Megamenu\Walker_Nav_Menu : '',
											)
										);
										?>
									</div>
									<div class="main-menu-three__search-cat">
										<?php if (('yes' == $search_status)) : ?>
											<div class="main-menu-three__search-box">
												<a href="#" class="main-menu-three__search search-toggler icon-magnifying-glass"></a>
											</div>
										<?php endif; ?>
										<?php if (('yes' == $login_status)) : ?>
											<div class="main-menu-three__cat-box">
												<a <?php echo esc_attr(!empty($settings['login_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['login_url']['url']); ?>" class="main-menu-three__cart icon-avatar"></a>
											</div>
										<?php endif; ?>
										<?php if (('yes' == $cart_status) && class_exists('WooCommerce')) : ?>
											<div class="main-menu-three__cat-box">
												<a href="<?php echo esc_url(wc_get_cart_url()); ?>" class="main-menu-three__cart icon-shopping-cart"></a>
											</div>
										<?php endif; ?>
									</div>
								</div>
							</div>
							<?php if (!empty($settings['btn_text'])) : ?>
								<div class="main-menu-three__btn-box">
									<a <?php echo esc_attr(!empty($settings['btn_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['btn_url']['url']); ?>" class="main-menu-three__btn"> <span class="fa fa-heart"></span>
										<?php echo esc_html($settings['btn_text']); ?>
									</a>
								</div>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
		</nav>
	</header>
	<?php if (get_theme_mod('header_sticky_menu') == 'yes' && !is_admin_bar_showing()) : ?>
		<div class="stricky-header stricked-menu main-menu main-menu-three">
			<div class="sticky-header__content"></div><!-- /.sticky-header__content -->
		</div><!-- /.stricky-header -->
	<?php endif; ?>
<?php endif; ?>

<div class="mobile-nav__wrapper">
	<div class="mobile-nav__overlay mobile-nav__toggler"></div>
	<!-- /.mobile-nav__overlay -->
	<div class="mobile-nav__content">
		<span class="mobile-nav__close mobile-nav__toggler"></span>

		<div class="logo-box">
			<a href="<?php echo esc_url(home_url('/')); ?>">
				<img width="<?php echo esc_attr($settings['logo_dimension']['width']); ?>" height="<?php echo esc_attr($settings['logo_dimension']['height']); ?>" src="<?php echo esc_attr($settings['mobile_menu_logo']['url']); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>">
			</a>
		</div>
		<!-- /.logo-box -->
		<div class="mobile-nav__container"></div>
		<!-- /.mobile-nav__container -->
		<?php if (!empty($settings['mobile_menu_email']) && !empty($settings['mobile_menu_phone'])) : ?>
			<ul class="mobile-nav__contact list-unstyled ml-0">
				<?php if (!empty($settings['mobile_menu_email'])) : ?>
					<li>
						<i class="fa fa-envelope"></i>
						<a href="mailto:<?php echo esc_attr($settings['mobile_menu_email']); ?>"><?php echo esc_html($settings['mobile_menu_email']); ?></a>
					</li>
				<?php endif; ?>
				<?php if (!empty($settings['mobile_menu_phone'])) : ?>
					<li>
						<i class="fa fa-phone-alt"></i>
						<a href="tel:<?php echo esc_attr(str_replace(' ', '-', $settings['mobile_menu_phone'])); ?>"><?php echo esc_html($settings['mobile_menu_phone']); ?></a>
					</li>
				<?php endif; ?>
			<?php endif; ?>
			</ul><!-- /.mobile-nav__contact -->
			<div class="mobile-nav__top">
				<div class="mobile-nav__social">
					<?php foreach ($settings['mobile_menu_social_icons'] as $social_icon) : ?>
						<a <?php echo esc_attr(!empty($social_icon['social_url']['is_external']) ? 'target=_blank' : ' '); ?> class="icon-svg" href="<?php echo esc_url($social_icon['social_url']['url']); ?>">
							<?php \Elementor\Icons_Manager::render_icon($social_icon['social_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
						</a>
					<?php endforeach; ?>
				</div><!-- /.mobile-nav__social -->
			</div><!-- /.mobile-nav__top -->
	</div>
	<!-- /.mobile-nav__content -->
</div>


<?php if ('yes' == $search_status) : ?>

	<div class="search-popup">
		<div class="search-popup__overlay search-toggler"></div>
		<!-- /.search-popup__overlay -->
		<div class="search-popup__content">
			<form action="<?php echo esc_url(home_url('/')); ?>">
				<label for="search" class="sr-only"><?php echo esc_html__('search here', 'oxpins-addon'); ?></label><!-- /.sr-only -->
				<input type="text" id="search" name="s" placeholder="<?php echo esc_attr_e('Search Here...', 'oxpins-addon'); ?>" />
				<button type="submit" aria-label="search submit" class="thm-btn">
					<i class="icon-magnifying-glass"></i>
				</button>
			</form>
		</div>
		<!-- /.search-popup__content -->
	</div>


<?php endif; ?>


<?php $oxpins_back_to_top_status = get_theme_mod('scroll_to_top', false); ?>
<?php if ('yes' == $oxpins_back_to_top_status) : ?>
	<a data-target="html" class="scroll-to-target scroll-to-top"><i class="fa <?php echo esc_attr(get_theme_mod('scroll_to_top_icon', 'fa-angle-up')); ?>"></i></a>

<?php endif; ?>