<?php if ('layout_one' == $settings['layout_type']) : ?>
    <!--Help Start-->
    <section class="help">
        <?php if (!empty($settings['background_image']['url'])) : ?>
            <div class="help-bg jarallax" data-jarallax data-speed="0.2" data-imgPosition="50% 0%" style="background-image: url(<?php echo esc_url($settings['background_image']['url']); ?>);"></div>
        <?php endif; ?>
        <?php if (!empty($settings['background_shape']['url'])) : ?>
            <div class="help-shape-1" style="background-image: url(<?php echo esc_url($settings['background_shape']['url']); ?>);"></div>
        <?php endif; ?>
        <div class="container">
            <div class="row">
                <?php if (is_array($settings['info_box_items'])) : ?>
                    <?php $i = 1;
                    foreach ($settings['info_box_items'] as $item) : ?>
                        <!--Help Single Start-->
                        <div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="<?php echo esc_attr($i); ?>00ms">
                            <div class="help__single">
                                <div class="help__single-inner">
                                    <div class="help__icon icon-svg-large">
                                        <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
                                    </div>
                                    <div class="help__content">
                                        <h4 class="help__title"><a <?php echo esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>"><?php echo esc_html($item['title']);  ?></a></h4>
                                        <p class="help__text"><?php echo wp_kses($item['summary'], 'oxpins_allowed_tags'); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--Help Single End-->
                    <?php $i++;
                    endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </section>
    <!--Help End-->
<?php endif; ?>