<?php if ('layout_three' == $settings['layout_type']) : ?>
    <!--Feature Four Start-->
    <section class="feature-four">
        <?php if (!empty($settings['layout_three_background_image']['url'])) : ?>
            <div class="feature-four-shape" style="background-image: url(<?php echo esc_url($settings['layout_three_background_image']['url']); ?>);"></div>
        <?php endif; ?>
        <div class="container">
            <div class="feature-four__inner">
                <div class="row">
                    <?php foreach ($settings['layout_three_info_box_items'] as $item) : ?>
                        <!--Feature Four Single Start-->
                        <div class="col-xl-4 col-lg-4">
                            <div class="feature-four__single">
                                <div class="feature-four__icon">
                                    <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
                                </div>
                                <div class="feature-four__content">
                                    <h3 class="feature-four__title"><?php echo wp_kses($item['title'], 'oxpins_allowed_tags'); ?></h3>
                                </div>
                            </div>
                        </div>
                        <!--Feature Four Single End-->
                    <?php endforeach; ?>
                </div>
                <?php if ('yes' == $settings['search_status']) : ?>
                    <div class="feature-four__search-box">
                        <form class="feature-four__form" action="<?php echo esc_url(home_url('/')); ?>">
                            <div class="feature-four__form-input">
                                <input type="search" name="s" placeholder="<?php echo esc_attr('Search here anything...', 'oxpins-addon'); ?>">
                                <button type="submit"><i class="icon-magnifying-glass"></i></button>
                            </div>
                        </form>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
    <!--Feature Four End-->
<?php endif; ?>