<?php if ('layout_one' == $settings['layout_type']) : ?>

	<div class="sidebar__post">
		<?php if (!empty($settings['background_image']['url'])) : ?>
			<div class="sidebar-shape-1" style="background-image: url(<?php echo esc_url($settings['background_image']['url']); ?>);"></div>
		<?php endif; ?>
		<?php if (!empty($settings['title'])) : ?>
			<h3 class="sidebar__title"><?php echo esc_html($settings['title']); ?></h3>
		<?php endif; ?>

		<ul class="sidebar__post-list list-unstyled ml-0">
			<?php
			if (!empty($settings['select_category'])) :
				$blog_post_one_query_args = array(
					'post_type' => 'post',
					'post_status' => 'publish',
					'ignore_sticky_posts' => true,
					'orderby' => 'date',
					'order'   => $settings['query_order'],
					'posts_per_page' => $settings['post_count']['size'],
					'tax_query' => array(
						array(
							'taxonomy' => 'category',
							'field' => 'slug',
							'terms' => $settings['select_category']
						)
					)
				);
			else :
				$blog_post_one_query_args = array(
					'post_type' => 'post',
					'post_status' => 'publish',
					'ignore_sticky_posts' => true,
					'orderby' => 'date',
					'order'   => $settings['query_order'],
					'posts_per_page' => $settings['post_count']['size'],
				);
			endif;
			$blog_post_one_query = new \WP_Query($blog_post_one_query_args);
			?>
			<?php $i = 1;
			while ($blog_post_one_query->have_posts()) :
				$blog_post_one_query->the_post(); ?>
				<li>
					<div class="sidebar__post-image">
						<?php the_post_thumbnail('oxpins_blog_70X68'); ?>
					</div>
					<div class="sidebar__post-content">
						<h3>
							<span class="sidebar__post-content-meta"><i class="fas fa-user-circle"></i> <?php esc_html_e('By', 'oxpins-addon'); ?> <?php the_author(); ?></span>
							<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
						</h3>
					</div>
				</li>
			<?php endwhile; ?>
			<?php wp_reset_postdata(); ?>
		</ul>
	</div>

<?php endif; ?>