<?php if ('layout_two' == $settings['layout_type']) : ?>
	<!--Team One Start-->
	<section class="team-one">
		<div class="container">
			<div class="row">
				<?php if (is_array($settings['team_items'])) : ?>
					<?php $i = 1;
					foreach ($settings['team_items'] as $item) : ?>
						<!--Team One Single Start-->
						<div class="col-xl-3 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay="<?php echo esc_attr($i); ?>00ms">
							<div class="team-one__single">
								<div class="team-one__img">
									<?php if (!empty($item['image']['url'])) : ?>
										<img src="<?php echo esc_url($item['image']['url']); ?>" alt="<?php echo esc_attr(oxpins_get_thumbnail_alt($item['image']['id'])); ?>">
									<?php endif; ?>
									<div class="team-one__social">
										<?php echo wp_kses($item['social'], 'oxpins_allowed_tags'); ?>
									</div>
								</div>
								<div class="team-one__content">
									<h3 class="team-one__name">
										<?php if (!empty($item['url']['url'])) : ?>
											<a href="<?php echo esc_url($item['url']['url']); ?>">
												<?php echo esc_html($item['name']); ?>
											</a>
										<?php else : ?>
											<?php echo esc_html($item['name']); ?>
										<?php endif; ?>
									</h3>
									<p class="team-one__sub-title"><?php echo esc_html($item['designation']); ?></p>
								</div>
							</div>
						</div>
						<!--Team One Single End-->
					<?php $i++;
					endforeach; ?>
				<?php endif; ?>
			</div>
		</div>
	</section>
	<!--Team One End-->
<?php endif; ?>