<?php if ('layout_one' == $settings['layout_type']) : ?>
	<!--Testimonial One Start-->
	<section class="testimonial-one">
		<?php if (!empty($settings['background_image']['url'])) : ?>
			<div class="testimonial-one-bg jarallax" data-jarallax data-speed="0.2" data-imgPosition="50% 0%" style="background-image: url(<?php echo esc_url($settings['background_image']['url']); ?>);"></div>
		<?php endif; ?>
		<div class="container">
			<div class="row">
				<div class="col-xl-6 col-lg-6">
					<div class="testimonial-one__left">
						<?php if (!empty($settings['sec_title']) || !empty($settings['sec_sub_title'])) : ?>
							<div class="section-title text-left">
								<?php if (!empty($settings['sec_sub_title'])) : ?>
									<span class="section-title__tagline"><?php echo wp_kses($settings['sec_sub_title'], 'oxpins_allowed_tags'); ?></span>
								<?php endif; ?>
								<?php if (!empty($settings['sec_title'])) : ?>
									<h2 class="section-title__title"><?php echo wp_kses($settings['sec_title'], 'oxpins_allowed_tags'); ?></h2>
								<?php endif; ?>
							</div>
						<?php endif; ?>
						<?php if (!empty($settings['summary'])) : ?>
							<p class="testimonial-one__text-1"><?php echo wp_kses($settings['summary'], 'oxpins_allowed_tags'); ?></p>
						<?php endif; ?>
						<?php if (!empty($settings['button_label'])) : ?>
							<a <?php echo esc_attr(!empty($settings['button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['button_url']['url']); ?>" class="thm-btn testimonial-one__btn"><?php echo esc_html($settings['button_label']); ?></a>
						<?php endif; ?>
					</div>
				</div>
				<div class="col-xl-6 col-lg-6">
					<div class="testimonial-one__right">
						<?php $i = 1;
						foreach ($settings['client_images'] as $item) : ?>
							<div class="testimonial-one__img-1 zoom-fade testimonial-one__img-<?php echo esc_attr($i); ?>">
								<img src="<?php echo esc_url($item['url']); ?>" alt="">
							</div>
						<?php $i++;
						endforeach; ?>

						<div class="testimonial-one__carousel owl-carousel owl-theme thm-owl__carousel" data-owl-options='<?php echo esc_attr(oxpins_get_owl_options($settings)); ?>'>
							<?php if (is_array($settings['testimonials'])) : ?>
								<?php foreach ($settings['testimonials'] as $item) : ?>
									<div class="item">
										<!--Testimonial One Single Start-->
										<div class="testimonial-one__single">
											<?php if (!empty($item['shape']['url'])) : ?>
												<div class="testimonial-one__shape-1" style="background-image: url(<?php echo esc_url($item['shape']['url']); ?>);"></div>
											<?php endif; ?>
											<div class="testimonial-one__client-img">
												<img src="<?php echo esc_url($item['image']['url']); ?>" alt="<?php echo esc_attr(oxpins_get_thumbnail_alt($item['image']['id'])); ?>">
											</div>
											<div class="testimonial-one__client-info">
												<h3 class="testimonial-one__client-name"><?php echo esc_html($item['name']); ?></h3>
												<p class="testimonial-one__client-sub-title"><?php echo esc_html($item['designation']); ?></p>
											</div>
											<div class="testimonial-one__quote icon-svg">
												<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
											</div>
											<p class="testimonial-one__text-2"><?php echo esc_html($item['testimonial']); ?></p>
										</div>
										<!--Testimonial One Single End-->
									</div>
								<?php endforeach; ?>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!--Testimonial One End-->
<?php endif; ?>