<?php if ('layout_three' == $settings['layout_type']) : ?>
	<!--Testimonial Three Start-->
	<section class="testimonial-three">
		<div class="container">
			<?php if (!empty($settings['layout_three_sec_title']) || !empty($settings['layout_three_sec_sub_title'])) : ?>
				<div class="section-title text-center">
					<?php if (!empty($settings['layout_three_sec_sub_title'])) : ?>
						<span class="section-title__tagline"><?php echo wp_kses($settings['layout_three_sec_sub_title'], 'oxpins_allowed_tags'); ?></span>
					<?php endif; ?>
					<?php if (!empty($settings['layout_three_sec_title'])) : ?>
						<h2 class="section-title__title"><?php echo wp_kses($settings['layout_three_sec_title'], 'oxpins_allowed_tags'); ?></h2>
					<?php endif; ?>
				</div>
			<?php endif; ?>
			<div class="testimonial-three__carousel owl-carousel owl-theme thm-owl__carousel" data-owl-options='<?php echo esc_attr(oxpins_get_owl_options($settings)); ?>'>
				<?php if (is_array($settings['layout_three_testimonial'])) : ?>
					<?php foreach ($settings['layout_three_testimonial'] as $item) : ?>
						<div class="item">
							<!--Testimonial Three Single Start-->
							<div class="testimonial-three__single">
								<?php if (!empty($item['image']['url'])) : ?>
									<div class="testimonial-three__client-img">
										<img src="<?php echo esc_url($item['image']['url']); ?>" alt="<?php echo esc_attr(oxpins_get_thumbnail_alt($item['image']['id'])); ?>">
									</div>
								<?php endif; ?>
								<div class="testimonial-three__client-info">
									<h3 class="testimonial-three__client-name"><?php echo esc_html($item['name']); ?></h3>
									<p class="testimonial-three__client-sub-title"><?php echo esc_html($item['designation']); ?></p>
								</div>
								<div class="testimonial-three__quote icon-svg">
									<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
								</div>

								<div class="testimonial-three__rating">
									<?php for ($i = 1; $i <= $item['rating']['size']; $i++) : ?>
										<i class="fa fa-star"></i>
									<?php endfor ?>
								</div>
								<?php if (!empty($item['shape']['url'])) : ?>
									<div class="testimonial-three__shape-1" style="background-image: url(<?php echo esc_url($item['shape']['url']); ?>);"></div>
								<?php endif; ?>
								<p class="testimonial-three__text-2"><?php echo esc_html($item['testimonial']); ?></p>
							</div>
							<!--Testimonial Three Single End-->
						</div>
					<?php endforeach; ?>
				<?php endif; ?>
			</div>
		</div>
	</section>
	<!--Testimonial Three End-->
<?php endif; ?>