<?php if ('layout_two' == $settings['layout_type']) : ?>
	<!--Testimonial Two Start-->
	<section class="testimonial-two">
		<div class="container">
			<?php if (!empty($settings['layout_two_sec_title']) || !empty($settings['layout_two_sec_sub_title'])) : ?>
				<div class="section-title text-center">
					<?php if (!empty($settings['layout_two_sec_sub_title'])) : ?>
						<span class="section-title__tagline"><?php echo wp_kses($settings['layout_two_sec_sub_title'], 'oxpins_allowed_tags'); ?></span>
					<?php endif; ?>
					<?php if (!empty($settings['layout_two_sec_title'])) : ?>
						<h2 class="section-title__title"><?php echo wp_kses($settings['layout_two_sec_title'], 'oxpins_allowed_tags'); ?></h2>
					<?php endif; ?>
				</div>
			<?php endif; ?>
			<div class="testimonial-two__carousel owl-carousel owl-theme thm-owl__carousel" data-owl-options='<?php echo esc_attr(oxpins_get_owl_options($settings)); ?>'>
				<?php if (is_array($settings['layout_two_testimonial'])) : ?>
					<?php foreach ($settings['layout_two_testimonial'] as $item) : ?>
						<div class="item">
							<!--Testimonial Two Single Start-->
							<div class="testimonial-two__single">
								<?php if (!empty($item['image']['url'])) : ?>
									<div class="testimonial-two__img">
										<img src="<?php echo esc_url($item['image']['url']); ?>" alt="<?php echo esc_attr(oxpins_get_thumbnail_alt($item['image']['id'])); ?>">
									</div>
								<?php endif; ?>
								<div class="testimonial-two__content">
									<?php if (!empty($item['shape']['url'])) : ?>
										<div class="testimonial-two__shape-1" style="background-image: url(<?php echo esc_url($item['shape']['url']); ?>);"></div>
									<?php endif; ?>
									<p class="testimonial-two__text"><?php echo esc_html($item['testimonial']); ?></p>
									<div class="testimonial-two__client-info">
										<h4 class="testimonial-two__client-name"><?php echo esc_html($item['name']); ?></h4>
										<p class="testimonial-two__client-sub-title"><?php echo esc_html($item['designation']); ?></p>
									</div>

									<div class="testimonial-two__rating">
										<?php for ($i = 1; $i <= $item['rating']['size']; $i++) : ?>
											<i class="fa fa-star"></i>
										<?php endfor ?>
									</div>

								</div>
							</div>
							<!--Testimonial Two Single End-->
						</div>
					<?php endforeach; ?>
				<?php endif; ?>
			</div>
		</div>
	</section>
	<!--Testimonial Two End-->
<?php endif; ?>