<?php

namespace Layerdrops\Oxpins;

class Assets
{

    /**
     * Class constructor
     */
    function __construct()
    {
        add_action('wp_enqueue_scripts', [$this, 'register_assets']);
        add_action('admin_enqueue_scripts', [$this, 'register_assets']);
    }

    /**
     * All available scripts
     *
     * @return array
     */
    public function get_scripts()
    {
        return [
            'bootstrap-select' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/bootstrap-select/js/bootstrap-select.min.js',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/bootstrap-select/js/bootstrap-select.min.js'),
                'deps'    => ['jquery', 'bootstrap']
            ],
            'jquery-bxslider' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/bxslider/jquery.bxslider.min.js',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/bxslider/jquery.bxslider.min.js'),
                'deps'    => ['jquery']
            ],
            'countdown' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/countdown/countdown.min.js',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/countdown/countdown.min.js'),
                'deps'    => ['jquery']
            ],
            'isotope' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/isotope/isotope.js',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/isotope/isotope.js'),
                'deps'    => ['jquery']
            ],
            'jarallax' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/jarallax/jarallax.min.js',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/jarallax/jarallax.min.js'),
                'deps'    => ['jquery']
            ],
            'jquery-ajaxchimp' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/jquery-ajaxchimp/jquery.ajaxchimp.min.js',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/jquery-ajaxchimp/jquery.ajaxchimp.min.js'),
                'deps'    => ['jquery']
            ],
            'jquery-appear' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/jquery-appear/jquery.appear.min.js',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/jquery-appear/jquery.appear.min.js'),
                'deps'    => ['jquery']
            ],
            'jquery-tilt' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/jquery-tilt/tilt.jquery.min.js',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/jquery-tilt/tilt.jquery.min.js'),
                'deps'    => ['jquery']
            ],
            'jquery-easing' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/jquery-easing/jquery.easing.min.js',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/jquery-easing/jquery.easing.min.js'),
                'deps'    => ['jquery']
            ],
            'jquery-circle-progress' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/jquery-circle-progress/jquery.circle-progress.min.js',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/jquery-circle-progress/jquery.circle-progress.min.js'),
                'deps'    => ['jquery']
            ],
            'jquery-magnific-popup' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/jquery-magnific-popup/jquery.magnific-popup.min.js',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/jquery-magnific-popup/jquery.magnific-popup.min.js'),
                'deps'    => ['jquery']
            ],
            'odometer' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/odometer/odometer.min.js',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/odometer/odometer.min.js'),
                'deps'    => ['jquery']
            ],
            'owl-carousel' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/owl-carousel/owl.carousel.min.js',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/owl-carousel/owl.carousel.min.js'),
                'deps'    => ['jquery']
            ],
            'swiper' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/swiper/swiper.min.js',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/swiper/swiper.min.js'),
                'deps'    => ['jquery']
            ],
            'wow' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/wow/wow.js',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/wow/wow.js'),
                'deps'    => ['jquery']
            ],

            'sharer' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/sharer/sharer.min.js',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/sharer/sharer.min.js'),
                'deps'    => ['jquery']
            ],

            'circleType' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/circleType/jquery.circleType.js',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/circleType/jquery.circleType.js'),
                'deps'    => ['jquery']
            ],
            'lettering' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/circleType/jquery.lettering.min.js',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/circleType/jquery.lettering.min.js'),
                'deps'    => ['jquery']
            ],
            'select2' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/select2/js/select2.min.js',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/select2/js/select2.min.js'),
                'deps'    => ['jquery']
            ],
            'oxpins-ui' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/jquery-ui/jquery-ui.js',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/jquery-ui/jquery-ui.js'),
                'deps'    => ['jquery']
            ],
            'oxpins-addon-customizer' => [
                'src'     => OXPINS_ADDON_ASSETS . '/js/oxpins-addon-customizer.js',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/js/oxpins-addon-customizer.js'),
                'deps'    => ['jquery', 'select2']
            ],
            'oxpins-addon-script' => [
                'src'     => OXPINS_ADDON_ASSETS . '/js/oxpins-addon.js',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/js/oxpins-addon.js'),
                'deps'    => ['jquery']
            ],

            'oxpins-addon-metaboxes-tab-script' => [
                'src'     => OXPINS_ADDON_ASSETS . '/js/admin/metaboxes/oxpins-addon-tab.js',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/js/admin/metaboxes/oxpins-addon-tab.js'),
                'deps'    => ['jquery']
            ]
        ];
    }

    /**
     * All available styles
     *
     * @return array
     */
    public function get_styles()
    {
        return [
            'animate' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/animate/animate.min.css',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/animate/animate.min.css')
            ],
            'custom-animate' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/animate/custom-animate.css',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/animate/custom-animate.css')
            ],
            'bootstrap-select' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/bootstrap-select/css/bootstrap-select.min.css',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/bootstrap-select/css/bootstrap-select.min.css')
            ],
            'bxslider' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/bxslider/jquery.bxslider.css',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/bxslider/jquery.bxslider.css')
            ],
            'jarallax' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/jarallax/jarallax.css',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/jarallax/jarallax.css')
            ],
            'jquery-magnific-popup' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/jquery-magnific-popup/jquery.magnific-popup.css',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/jquery-magnific-popup/jquery.magnific-popup.css')
            ],
            'odometer' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/odometer/odometer.min.css',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/odometer/odometer.min.css')
            ],
            'owl-carousel' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/owl-carousel/owl.carousel.min.css',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/owl-carousel/owl.carousel.min.css')
            ],
            'owl-theme' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/owl-carousel/owl.theme.default.min.css',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/owl-carousel/owl.theme.default.min.css')
            ],
            'the-sayinistic-font' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/the-sayinistic-font/stylesheet.css',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/the-sayinistic-font/stylesheet.css')
            ],
            'swiper' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/swiper/swiper.min.css',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/swiper/swiper.min.css')
            ],
            'select2' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/select2/css/select2.min.css',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/select2/css/select2.min.css')
            ],
            'oxpins-ui' => [
                'src'     => OXPINS_ADDON_ASSETS . '/vendors/jquery-ui/jquery-ui.css',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/vendors/jquery-ui/jquery-ui.css')
            ],
            'oxpins-addon-style' => [
                'src'     => OXPINS_ADDON_ASSETS . '/css/oxpins-addon.css',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/css/oxpins-addon.css')
            ],
            'oxpins-addon-style' => [
                'src'     => OXPINS_ADDON_ASSETS . '/css/oxpins-addon.css',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/css/oxpins-addon.css')
            ],
            'oxpins-addon-admin-style' => [
                'src'     => OXPINS_ADDON_ASSETS . '/css/oxpins-addon-admin.css',
                'version' => filemtime(OXPINS_ADDON_PATH . '/assets/css/oxpins-addon-admin.css')
            ]
        ];
    }

    /**
     * Register scripts and styles
     *
     * @return void
     */
    public function register_assets()
    {
        $scripts = $this->get_scripts();
        $styles  = $this->get_styles();

        foreach ($scripts as $handle => $script) {
            $deps = isset($script['deps']) ? $script['deps'] : false;

            wp_register_script($handle, $script['src'], $deps, $script['version'], true);
        }

        foreach ($styles as $handle => $style) {
            $deps = isset($style['deps']) ? $style['deps'] : false;

            wp_register_style($handle, $style['src'], $deps, $style['version']);
        }
    }
}
