<?php

namespace Layerdrops\Oxpins\Metaboxes;


class Event
{
    function __construct()
    {
        add_action('cmb2_admin_init', [$this, 'add_metabox']);
    }

    function add_metabox()
    {
        $prefix = 'oxpins_event_';

        $general = new_cmb2_box(array(
            'id'           => $prefix . 'event_option',
            'title'        => __('Event Options', 'oxpins-addon'),
            'object_types' => array('event'),
            'context'      => 'normal',
            'priority'     => 'default',
        ));

        $general->add_field(array(
            'name' => __('Starting Time', 'oxpins-addon'),
            'id' => $prefix . 'starting_time',
            'type' => 'text',
        ));

        $general->add_field(array(
            'name' => __('End Time', 'oxpins-addon'),
            'id' => $prefix . 'end_time',
            'type' => 'text',
        ));

        $general->add_field(array(
            'name' => __('Event Date', 'oxpins-addon'),
            'id' => $prefix . 'date',
            'type' => 'text_date',
            'date_format' => 'Y-m-d',
        ));

        $general->add_field(array(
            'name' => __('Phone', 'oxpins-addon'),
            'id' => $prefix . 'phone',
            'type' => 'text',
        ));

        $general->add_field(array(
            'name' => __('Location', 'oxpins-addon'),
            'id' => $prefix . 'location',
            'type' => 'text',
        ));

        $general->add_field(array(
            'name' => __('Country', 'oxpins-addon'),
            'id' => $prefix . 'country',
            'type' => 'text',
        ));

        $general->add_field(array(
            'name' => __('Set Map Location', 'oxpins-addon'),
            'id' => $prefix . 'map',
            'type' => 'text',
            'default' => 'London Eye, London, United Kingdom'
        ));

        $general->add_field(array(
            'name'        => __('Map Zoom', 'oxpins-addon'),
            'id'          => $prefix . 'zoom',
            'type'        => 'own_slider',
            'min'         => '0',
            'max'         => '200',
            'step'        => '5',
            'default'     => '10', // start value
        ));

        $general->add_field(array(
            'name' => __('Register Button Label', 'oxpins-addon'),
            'id' => $prefix . 'btn_label',
            'type' => 'text',
        ));

        $general->add_field(array(
            'name' => __('Register Button Url', 'oxpins-addon'),
            'id' => $prefix . 'btn_url',
            'type' => 'text',
        ));

        //Social Network
        $social_network = new_cmb2_box(array(
            'id'           => $prefix . 'social_network_option',
            'title'        => __('Social Network', 'oxpins-addon'),
            'object_types' => array('event'),
            'context'      => 'normal',
            'priority'     => 'default',
        ));

        $event_social_network = $social_network->add_field(array(
            'id' => $prefix . 'social_network',
            'type' => 'group',
            'options'     => array(
                'group_title'    => esc_html__('Social Network {#}', 'oxpins-addon'), // {#} gets replaced by row number
                'add_button'     => esc_html__('Add Another Social Network Item', 'oxpins-addon'),
                'remove_button'  => esc_html__('Remove Social Network Item', 'oxpins-addon'),
                'sortable'       => false,
                'closed'      => true, // true to have the groups closed by default
                // 'remove_confirm' => esc_html__( 'Are you sure you want to remove?', 'oxpins-addon' ), // Performs confirmation before removing group.
            ),
        ));


        $social_network->add_group_field($event_social_network, array(
            'name' => __('Social Network Icon', 'oxpins-addon'),
            'id' => $prefix . 'social_network_icon',
            'type' => 'pw_select',
            'default' => 'icon-data-analytics',
            'options' => oxpins_get_fa_icons(),
        ));


        $social_network->add_group_field($event_social_network, array(
            'name' => __('Is FontAwesome Icon?', 'oxpins-addon'),
            'id'               => $prefix . 'feature_is_fontawesome',
            'type'             => 'radio',
            'default'          => 'yes',
            'show_option_none' => false,
            'options'          => array(
                'yes' => __('Yes', 'oxpins-addon'),
                'no'   => __('No', 'oxpins-addon'),
            ),
        ));


        $social_network->add_group_field($event_social_network, array(
            'name' => __('Type of FontAwesome?', 'oxpins-addon'),
            'id'               => $prefix . 'feature_fontawesome_type',
            'type'             => 'radio',
            'show_option_none' => false,
            'options'          => array(
                'fas' => __('Solid', 'oxpins-addon'),
                'far'   => __('Regular', 'oxpins-addon'),
                'fal'   => __('Light', 'oxpins-addon'),
                'fab'   => __('Brands', 'oxpins-addon'),
            ),
            'default' => 'fab',
            'attributes' => array(
                'data-conditional-id'    => wp_json_encode(array($event_social_network, 'oxpins_event_feature_is_fontawesome')),
                'data-conditional-value' => 'yes',
            ),
        ));



        $social_network->add_group_field($event_social_network, array(
            'name' => __('Social Network Url', 'oxpins-addon'),
            'id' => $prefix . 'social_network_url',
            'type' => 'text',
            'default' => '#'
        ));
    }
}
