<?php

namespace Layerdrops\Oxpins\Metaboxes;


class GiveForm
{
    function __construct()
    {
        add_action('cmb2_admin_init', [$this, 'add_metabox']);
    }

    function add_metabox()
    {
        $prefix = 'oxpins_';

        $general = new_cmb2_box(array(
            'id'           => $prefix . 'give_form_option',
            'title'        => __('Give Form Options', 'oxpins-addon'),
            'object_types' => array('give_forms'),
            'context'      => 'normal',
            'priority'     => 'default',
        ));

        $general->add_field(array(
            'name' => __('Show Donation Button', 'oxpins-addon'),
            'id' => $prefix . 'give_form_show_donation_button',
            'type' => 'radio',
            'default' => 'on',
            'options' => array(
                'on' => __('On', 'oxpins-addon'),
                'off' => __('Off', 'oxpins-addon'),
            ),
        ));

        $orgizer = new_cmb2_box(array(
            'id'           => $prefix . 'give_form_organizer_option',
            'title'        => __('Give Form Organizer Options', 'oxpins-addon'),
            'object_types' => array('give_forms'),
            'context'      => 'normal',
            'priority'     => 'default',
        ));


        $orgizer->add_field(array(
            'name' => __('Organizer Name', 'oxpins-addon'),
            'id' => $prefix . 'give_form_organizer_name',
            'type' => 'text',
        ));

        $orgizer->add_field(array(
            'name' => __('location', 'oxpins-addon'),
            'id' => $prefix . 'give_form_organizer_location',
            'type' => 'text',
        ));

        $orgizer->add_field(array(
            'name'    => __('Organizer Image', 'oxpins-addon'),
            'id'      => $prefix . 'give_form_organizer_image',
            'type'    => 'file',
            // Optional:
            'options' => array(
                'url' => false, // Hide the text input for the url
            ),
        ));
    }
}
