<?php

namespace Layerdrops\Oxpins;

class Utility
{
    public function __construct()
    {
        $this->register_image_size();
        add_filter('single_template', [$this, 'load_portfolio_template']);
        add_filter('single_template', [$this, 'load_event_template']);
        add_filter('single_template', [$this, 'load_give_form_template'], 1);
        remove_action('give_single_form_summary', 'give_template_single_title', 5);
    }
    public function register_image_size()
    {
        add_image_size('oxpins_blog_370X250', 370, 250, true); // in use
        add_image_size('oxpins_blog_268X170', 268, 170, true); // in use
        add_image_size('oxpins_blog_570X378', 570, 378, true); // in use
        add_image_size('oxpins_blog_70X68', 70, 68, true); // in use

        add_image_size('oxpins_give_form_370X250', 370, 250, true); // in use
        add_image_size('oxpins_give_form_370X338', 370, 338, true); // in use
        add_image_size('oxpins_give_form_585X467', 585, 467, true); // in use
        add_image_size('oxpins_give_form_770X400', 770, 400, true); // in use

        add_image_size('oxpins_brand_logo_112X80', 112, 80, true); // in use

        add_image_size('oxpins_event_270X355', 270, 355, true); // in use
        add_image_size('oxpins_event_240X184', 240, 184, true); // in use
        add_image_size('oxpins_event_370X470', 370, 470, true); // in use
        add_image_size('oxpins_event_370X250', 370, 250, true); // in use
    }

    public function load_portfolio_template($template)
    {
        global $post;

        if ('portfolio' === $post->post_type && locate_template(array('single-portfolio.php')) !== $template) {
            /*
            * This is a 'portfolio' post
            * AND a 'single portfolio template' is not found on
            * theme or child theme directories, so load it
            * from our plugin directory.
            */
            return OXPINS_ADDON_PATH . '/post-templates/single-portfolio.php';
        }

        return $template;
    }

    public function load_event_template($template)
    {
        global $post;

        if ('event' === $post->post_type && locate_template(array('single-event.php')) !== $template) {
            /*
            * This is a 'event' post
            * AND a 'single event template' is not found on
            * theme or child theme directories, so load it
            * from our plugin directory.
            */
            return OXPINS_ADDON_PATH . '/post-templates/single-event.php';
        }

        return $template;
    }

    public function load_give_form_template($template)
    {
        global $post;

        if ('give_forms' === $post->post_type && locate_template(array('single-give-form.php')) !== $template) {
            /*
            * This is a 'give-form' post
            * AND a 'single give-form template' is not found on
            * theme or child theme directories, so load it
            * from our plugin directory.
            */
            return OXPINS_ADDON_PATH . '/post-templates/single-give-form.php';
        }

        return $template;
    }
}
