<?php

namespace Layerdrops\Oxpins\Widgets;


class About extends \Elementor\Widget_Base
{
	public function get_name()
	{
		return 'oxpins-about';
	}

	public function get_title()
	{
		return __('About', 'oxpins-addon');
	}

	public function get_icon()
	{
		return 'eicon-cogs';
	}

	public function get_categories()
	{
		return ['oxpins-category'];
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'oxpins-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'oxpins-addon'),
					'layout_two' => __('Layout Two', 'oxpins-addon'),
					'layout_three' => __('Layout Three', 'oxpins-addon'),
					'layout_four' => __('Layout Four', 'oxpins-addon'),
				]
			]
		);

		$this->end_controls_section();

		//layout_one
		$this->start_controls_section(
			'content_one',
			[
				'label' => __('Content', 'oxpins-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'layout_type' => 'layout_one'
				]
			]
		);

		$this->add_control(
			'sec_title',
			[
				'label' => __('Section Title', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add title', 'oxpins-addon'),
				'default' => __('Default title', 'oxpins-addon'),
			]
		);

		$this->add_control(
			'sec_sub_title',
			[
				'label' => __('Section Sub Title', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => __('Sub sub title', 'oxpins-addon'),
			]
		);

		$this->add_control(
			'highlighted_text',
			[
				'label' => __('Highlighted Text', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => __('Default highlighted text', 'oxpins-addon'),
			]
		);

		$this->add_control(
			'summary',
			[
				'label' => __('Summary', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => __('Default summary', 'oxpins-addon'),
			]
		);


		$this->add_control(
			'button_label',
			[
				'label' => __('Button Text', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Discover More', 'oxpins-addon'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'button_url',
			[
				'label' => __('Button Url', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __('#', 'oxpins-addon'),
				'show_external' => false,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
				'show_label' => false,
			]
		);

		$layout_one_features_list = new \Elementor\Repeater();

		$layout_one_features_list->add_control(
			'title',
			[
				'label' => __('Title', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Join our team', 'oxpins-addon'),
			]
		);

		$layout_one_features_list->add_control(
			'url',
			[
				'label' => __('Url', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __('#', 'oxpins-addon'),
				'show_external' => false,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
				'show_label' => false,
			]
		);

		$layout_one_features_list->add_control(
			'text',
			[
				'label' => __('Text', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => __('Default Text', 'oxpins-addon'),
			]
		);

		$layout_one_features_list->add_control(
			'icon',
			[
				'label' => __('Check Icon', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'icon-volunteer',
					'library' => 'custom-icon',
				],
			]
		);


		$this->add_control(
			'layout_one_features_list',
			[
				'label' => __('Feature Lists', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $layout_one_features_list->get_controls(),
				'prevent_empty' => false,
				'title_field' => '{{{ title }}}',
			]
		);

		$this->end_controls_section();

		//images
		$this->start_controls_section(
			'section_image',
			[
				'label' => __('Images', 'oxpins-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'layout_type' => 'layout_one'
				]
			]
		);


		$this->add_control(
			'image',
			[
				'label' => __('Image', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);


		$this->add_control(
			'image_caption',
			[
				'label' => __('Image Caption', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => __('25 YEARS EXPERIENCE OXPINS CHARITY CENTER', 'oxpins-addon'),
			]
		);

		$this->add_control(
			'caption_image',
			[
				'label' => __('Caption Image', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);


		$this->add_control(
			'shapes',
			[
				'label' => __('Shapes', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::GALLERY,
				'default' => [],
			]
		);


		$this->end_controls_section();


		//layout_two_content
		$this->start_controls_section(
			'layout_two_content',
			[
				'label' => __('Content', 'oxpins-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'layout_type' => 'layout_two'
				]
			]
		);

		$this->add_control(
			'layout_two_sec_title',
			[
				'label' => __('Section Title', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add title', 'oxpins-addon'),
				'default' => __('Default Title', 'oxpins-addon'),
			]
		);

		$this->add_control(
			'layout_two_sec_sub_title',
			[
				'label' => __('Section Sub Title', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add sub title', 'oxpins-addon'),
				'default' => __('Default Sub Title', 'oxpins-addon'),
			]
		);

		$this->add_control(
			'layout_two_summary',
			[
				'label' => __('Summary', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add summary', 'oxpins-addon'),
				'default' => __('Default Summary Text', 'oxpins-addon'),
			]
		);

		$this->add_control(
			'layout_two_button_label',
			[
				'label' => __('Button Text', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Discover More', 'oxpins-addon'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'layout_two_button_url',
			[
				'label' => __('Button Url', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __('#', 'oxpins-addon'),
				'show_external' => false,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
				'show_label' => false,
			]
		);

		$layout_two_features_list = new \Elementor\Repeater();

		$layout_two_features_list->add_control(
			'title',
			[
				'label' => __('Title', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add title', 'oxpins-addon'),
				'default' => __('Default Title', 'oxpins-addon'),
			]
		);

		$layout_two_features_list->add_control(
			'text',
			[
				'label' => __('Text', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add Text', 'oxpins-addon'),
				'default' => __('Default Text', 'oxpins-addon'),
			]
		);

		$layout_two_features_list->add_control(
			'icon',
			[
				'label' => __('Icon', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'icon-target',
					'library' => 'custom-icon',
				],
			]
		);


		$this->add_control(
			'layout_two_features_list',
			[
				'label' => __('Feature Lists', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $layout_two_features_list->get_controls(),
				'prevent_empty' => false,
				'title_field' => '{{{ title }}}',
			]
		);

		$layout_two_progress_bar = new \Elementor\Repeater();

		$layout_two_progress_bar->add_control(
			'title',
			[
				'label' => __('Title', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add title', 'oxpins-addon'),
				'default' => __('Default Title', 'oxpins-addon'),
			]
		);

		$layout_two_progress_bar->add_control(
			'count',
			[
				'label' => __('Count', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['count'],
				'range' => [
					'count' => [
						'min' => 1,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'count',
					'size' => 80,
				],
			]
		);


		$this->add_control(
			'layout_two_progress_bar',
			[
				'label' => __('Progress Bar', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $layout_two_progress_bar->get_controls(),
				'prevent_empty' => false,
				'title_field' => '{{{ title }}}',
			]
		);

		$this->end_controls_section();

		//layout_two_images
		$this->start_controls_section(
			'layout_two_section_image',
			[
				'label' => __('Images', 'oxpins-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'layout_type' => 'layout_two'
				]
			]
		);


		$this->add_control(
			'layout_two_image_one',
			[
				'label' => __('Image', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);


		$this->add_control(
			'layout_two_image_two',
			[
				'label' => __('Image Two', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'layout_two_image_caption',
			[
				'label' => __('Image Caption', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add Image Caption', 'oxpins-addon'),
				'default' => __('Default Caption Text', 'oxpins-addon'),
			]
		);

		$this->add_control(
			'layout_two_shape',
			[
				'label' => __('Shapes', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::GALLERY,
				'default' => [],
			]
		);

		$this->end_controls_section();

		//layout_three_content
		$this->start_controls_section(
			'layout_three_content',
			[
				'label' => __('Content', 'oxpins-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'layout_type' => 'layout_three'
				]
			]
		);

		$this->add_control(
			'layout_three_sec_title',
			[
				'label' => __('Section Title', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add title', 'oxpins-addon'),
				'default' => __('Default Title', 'oxpins-addon'),
			]
		);

		$this->add_control(
			'layout_three_sec_sub_title',
			[
				'label' => __('Section Sub Title', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add sub title', 'oxpins-addon'),
				'default' => __('Default Sub Title', 'oxpins-addon'),
			]
		);

		$this->add_control(
			'layout_three_summary',
			[
				'label' => __('Summary', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add summary', 'oxpins-addon'),
				'default' => __('Default summary text', 'oxpins-addon'),
			]
		);

		$this->add_control(
			'layout_three_summary_two',
			[
				'label' => __('Bottom Summary', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add Bottom summary', 'oxpins-addon'),
				'default' => __('Default summary text', 'oxpins-addon'),
			]
		);

		$this->add_control(
			'layout_three_button_label',
			[
				'label' => __('Button Text', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Discover More', 'oxpins-addon'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'layout_three_button_url',
			[
				'label' => __('Button Url', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __('#', 'oxpins-addon'),
				'show_external' => false,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
				'show_label' => false,
			]
		);

		$this->end_controls_section();

		//layout_three_images
		$this->start_controls_section(
			'layout_three_section_image',
			[
				'label' => __('Images', 'oxpins-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'layout_type' => 'layout_three'
				]
			]
		);


		$this->add_control(
			'layout_three_image',
			[
				'label' => __('Image', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'layout_three_image_two',
			[
				'label' => __('Image Two', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);


		$this->add_control(
			'layout_three_image_caption_count',
			[
				'label' => __('Image Caption Count Text', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default'	  => __('280', 'oxpins-addon')
			]
		);

		$this->add_control(
			'layout_three_image_count_sign',
			[
				'label' => __('Image Caption Count Sign', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default'	  => __('k', 'oxpins-addon')
			]
		);

		$this->add_control(
			'layout_three_image_caption',
			[
				'label' => __('Image Caption', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add image caption', 'oxpins-addon'),
				'default'	  => __('Default Text', 'oxpins-addon')
			]
		);

		$this->add_control(
			'layout_three_caption_image',
			[
				'label' => __('Caption Background Image', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);


		$this->end_controls_section();

		//layout_four
		$this->start_controls_section(
			'layout_four_content',
			[
				'label' => __('Content', 'oxpins-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'layout_type' => 'layout_four'
				]
			]
		);

		$this->add_control(
			'layout_four_sec_title',
			[
				'label' => __('Section Title', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add title', 'oxpins-addon'),
				'default' => __('Default title', 'oxpins-addon'),
			]
		);

		$this->add_control(
			'layout_four_sec_sub_title',
			[
				'label' => __('Section Sub Title', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add sub title', 'oxpins-addon'),
				'default' => __('Default sub title', 'oxpins-addon'),
			]
		);

		$this->add_control(
			'layout_four_summary',
			[
				'label' => __('Summary', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add summary', 'oxpins-addon'),
				'default' => __('Default summary', 'oxpins-addon'),
			]
		);

		$layout_four_check_list = new \Elementor\Repeater();

		$layout_four_check_list->add_control(
			'title',
			[
				'label' => __('Title', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __('Add title', 'oxpins-addon'),
				'default' => __('Default Title', 'oxpins-addon'),
				'label_block' => true
			]
		);


		$layout_four_check_list->add_control(
			'icon',
			[
				'label' => __('Check Icon', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fa fa-check',
					'library' => 'custom-icon',
				],
			]
		);


		$this->add_control(
			'layout_four_check_list',
			[
				'label' => __('Check List', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $layout_four_check_list->get_controls(),
				'prevent_empty' => false,
				'title_field' => '{{{ title }}}',
			]
		);


		$this->add_control(
			'layout_four_button_label',
			[
				'label' => __('Button Label', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Discover More', 'oxpins-addon'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'layout_four_button_url',
			[
				'label' => __('Button Url', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __('#', 'oxpins-addon'),
				'show_external' => false,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
				'show_label' => false,
			]
		);

		$this->end_controls_section();

		//layout_four_images
		$this->start_controls_section(
			'layout_four_section_image',
			[
				'label' => __('Images', 'oxpins-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'layout_type' => 'layout_four'
				]
			]
		);


		$this->add_control(
			'layout_four_image',
			[
				'label' => __('Image', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);


		$this->add_control(
			'layout_four_image_two',
			[
				'label' => __('Image Two', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->end_controls_section();

		//typos
		$this->start_controls_section(
			'style_options',
			[
				'label' => esc_html__('Style Options', 'oxpins-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		oxpins_typo_and_color_options($this, 'Title', '{{WRAPPER}} .section-title__title', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
		oxpins_typo_and_color_options($this, 'Sub Title', '{{WRAPPER}} .section-title__tagline', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);


		oxpins_typo_and_color_options($this, 'Summary Text', '{{WRAPPER}} .about-one__text,{{WRAPPER}} .about-two__text-1, {{WRAPPER}} .about-three__text-1, {{WRAPPER}} .about-three__text-2, {{WRAPPER}} .about-four__text', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
		oxpins_typo_and_color_options($this, 'Highlight Text', '{{WRAPPER}} .about-one__fund-text', ['layout_one']);

		oxpins_typo_and_color_options($this, 'Progress Bar Title ', '{{WRAPPER}} .about-two__progress-title', ['layout_two']);

		oxpins_typo_and_color_options($this, 'Check Title ', '{{WRAPPER}} .about-four__points li .text p', ['layout_four']);

		oxpins_typo_and_color_options($this, 'Feature Title', '{{WRAPPER}} .about-one__points li .text h5 a,{{WRAPPER}} .about-two__points li .text h4', ['layout_one', 'layout_two']);
		oxpins_typo_and_color_options($this, 'Feature Text', '{{WRAPPER}} .about-one__points li .text p,{{WRAPPER}} .about-two__points li .text p', ['layout_one', 'layout_two']);

		oxpins_typo_and_color_options($this, 'Button', '{{WRAPPER}} .thm-btn,{{WRAPPER}} .about-two__btn,{{WRAPPER}} .about-three__btn', ['layout_one', 'layout_three', 'layout_four']);
		oxpins_typo_and_color_options($this, 'Button Background', '{{WRAPPER}} .thm-btn,{{WRAPPER}} .about-two__btn,{{WRAPPER}} .about-three__btn', ['layout_one', 'layout_three', 'layout_four'], 'background-color', false);

		oxpins_typo_and_color_options($this, 'Image Caption', '{{WRAPPER}} .about-two__left-title,{{WRAPPER}} .about-three__help-text', ['layout_two', 'layout_three']);
		oxpins_typo_and_color_options($this, 'Image Caption Count', '{{WRAPPER}} .about-three__help-count h3, {{WRAPPER}} .about-three__help-letter', ['layout_three']);

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include oxpins_get_template('about-one.php');
		include oxpins_get_template('about-two.php');
		include oxpins_get_template('about-three.php');
		include oxpins_get_template('about-four.php');
	}
}
