<?php

namespace Layerdrops\Oxpins\Widgets;


class Blog extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'oxpins-blog';
    }

    public function get_title()
    {
        return __('Blog', 'oxpins-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['oxpins-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'oxpins-addon'),
                    'layout_two' => __('Layout Two', 'oxpins-addon'),
                    'layout_three' => __('Layout Three', 'oxpins-addon'),
                    'layout_four' => __('Layout Four', 'oxpins-addon'),
                    'layout_five' => __('Layout Five', 'oxpins-addon'),
                ]
            ]
        );

        $this->add_control(
            'pagination_status',
            [
                'label' => __('Enable Pagination?', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'oxpins-addon'),
                'label_off' => __('No', 'oxpins-addon'),
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_four']
                ]
            ]
        );


        $this->add_control(
            'title',
            [
                'label' => __('Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Add Title', 'oxpins-addon'),
                'default' => __('Default Title', 'oxpins-addon'),
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_two', 'layout_three']
                ]
            ]
        );

        $this->add_control(
            'sub_title',
            [
                'label' => __('Sub Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Add Sub Title', 'oxpins-addon'),
                'default' => __('Default Title', 'oxpins-addon'),
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_two', 'layout_three']
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Post Options', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
            'post_count',
            [
                'label' => __('Number Of Posts', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['count'],
                'range' => [
                    'count' => [
                        'min' => 0,
                        'max' => 15,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'count',
                    'size' => 6,
                ],
            ]
        );


        $this->add_control(
            'query_order',
            [
                'label' => __('Select Order', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'DESC',
                'options' => [
                    'DESC' => __('DESC', 'oxpins-addon'),
                    'ASC' => __('ASC', 'oxpins-addon'),
                ]
            ]
        );

        $this->add_control(
            'select_category',
            [
                'label' => __('Post Category', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => oxpins_get_taxonoy('category'),
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_three', 'layout_four', 'layout_five']
                ]
            ]
        );

        $this->add_control(
            'select_post',
            [
                'label'       => esc_html__('Select Left Post', 'oxpins-addon'),
                'label_block' => true,
                'type'        => \Elementor\Controls_Manager::SELECT,
                'options'     => oxpins_post_query('post'),
                'condition' => [
                    'layout_type' => 'layout_two'
                ]
            ]
        );

        $this->end_controls_section();

        //style
        $this->start_controls_section(
            'style_options',
            [
                'label' => esc_html__('Style Options', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        oxpins_typo_and_color_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one', 'layout_two', 'layout_three']);
        oxpins_typo_and_color_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline', ['layout_one', 'layout_two', 'layout_three']);

        oxpins_typo_and_color_options($this, 'Post Title', '{{WRAPPER}} .news-one__title a,{{WRAPPER}} .news-two__title-two a', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);
        oxpins_typo_and_color_options($this, 'Post Meta', '{{WRAPPER}} .news-one__meta li a,{{WRAPPER}} .news-two__meta-two li a', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);

        oxpins_typo_and_color_options($this, 'Post Date', '{{WRAPPER}} .news-one__date p, {{WRAPPER}} .blog-three__date p,{{WRAPPER}} .news-two__date-two p', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);
        oxpins_typo_and_color_options($this, 'Read More', '{{WRAPPER}} .news-one__read-more a', ['layout_one', 'layout_three', 'layout_five']);

        $this->end_controls_section();

        //style
        $this->start_controls_section(
            'left_post_options',
            [
                'label' => esc_html__('Left Sticky Post', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout_type' => 'layout_one'
                ]
            ]
        );

        oxpins_typo_and_color_options($this, 'Sticky Post Title', '{{WRAPPER}} .news-two__title-one a', ['layout_two']);
        oxpins_typo_and_color_options($this, 'Sticky Post Meta', '{{WRAPPER}} .news-two__meta-one li a', ['layout_two']);
        oxpins_typo_and_color_options($this, 'Sticky Post Date', '{{WRAPPER}} .news-two__date-one p', ['layout_two']);

        $this->end_controls_section();

        // load carousel options
        oxpins_get_elementor_carousel_options($this, 'layout_five');
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include oxpins_get_template('blog-one.php');
        include oxpins_get_template('blog-two.php');
        include oxpins_get_template('blog-three.php');
        include oxpins_get_template('blog-four.php');
        include oxpins_get_template('blog-five.php');
    }
}
