<?php

namespace Layerdrops\Oxpins\Widgets;


class CallToAction extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'oxpins-call-to-action';
    }

    public function get_title()
    {
        return __('Call To Action', 'oxpins-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['oxpins-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'oxpins-addon'),
                    'layout_two' => __('Layout Two', 'oxpins-addon'),
                ]
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Add Title', 'oxpins-addon'),
                'default' => __('Default Title', 'oxpins-addon'),
            ]
        );

        $this->add_control(
            'sub_title',
            [
                'label' => __('Sub Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Add Sub Title', 'oxpins-addon'),
                'default' => __('Default Sub Title', 'oxpins-addon'),
            ]
        );


        $this->add_control(
            'button_label',
            [
                'label' => __('Button Text', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Discover More', 'oxpins-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'button_url',
            [
                'label' => __('Button Url', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'oxpins-addon'),
                'show_external' => false,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'show_label' => false,
            ]
        );


        $this->add_control(
            'background_image_overlay_opacity',
            [
                'label' => __('Background Overlay Opacity', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_two']
                ],
                'selectors' => [
                    '{{WRAPPER}} .become-volunteer-one__bg-box,{{WRAPPER}} .become-volunteer' => 'background-color: {{VALUE}}',
                ],
            ]
        );


        $this->add_control(
            'image',
            [
                'label' => __(' Image', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
                'condition' => [
                    'layout_type' => 'layout_one'
                ],
            ]
        );

        $this->add_control(
            'shape',
            [
                'label' => __('Shape', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
                'condition' => [
                    'layout_type' => 'layout_one'
                ],
            ]
        );

        $this->end_controls_section();

        //typo options
        $this->start_controls_section(
            'style_options',
            [
                'label' => esc_html__('Style Options', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        oxpins_typo_and_color_options($this, 'Title', '{{WRAPPER}} .become-volunteer-one__title, {{WRAPPER}} .section-title__title', ['layout_one', 'layout_two']);
        oxpins_typo_and_color_options($this, 'Sub Title ', '{{WRAPPER}} .become-volunteer-one__title, {{WRAPPER}} .section-title__tagline', ['layout_one', 'layout_two']);
        oxpins_typo_and_color_options($this, 'Button', '{{WRAPPER}} .fundraishing__btn,{{WRAPPER}} .thm-btn', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
        oxpins_typo_and_color_options($this, 'Button Background', '{{WRAPPER}} .thm-btn', ['layout_one', 'layout_two', 'layout_three', 'layout_four'], 'background-color', false);
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include oxpins_get_template('call-to-action-one.php');
        include oxpins_get_template('call-to-action-two.php');
    }
}
