<?php

namespace Layerdrops\Oxpins\Widgets;


class ContactForm extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'oxpins-contact-form';
    }

    public function get_title()
    {
        return __('Contact Form', 'oxpins-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['oxpins-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'oxpins-addon'),
                    'layout_two' => __('Layout Two', 'oxpins-addon'),
                ]
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'sec_title',
            [
                'label' => __('Section Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Add Title', 'oxpins-addon'),
                'default' => __('Default Title', 'oxpins-addon'),
            ]
        );

        $this->add_control(
            'sec_sub_title',
            [
                'label' => __('Section Sub Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Add Sub Title', 'oxpins-addon'),
                'default' => __('Default Sub Title', 'oxpins-addon'),
            ]
        );

        $this->add_control(
            'select_wpcf7_form',
            [
                'label'       => esc_html__('Select your contact form 7', 'oxpins-addon'),
                'label_block' => true,
                'type'        => \Elementor\Controls_Manager::SELECT,
                'options'     => oxpins_post_query('wpcf7_contact_form'),
            ]
        );

        $this->add_control(
            'bg_image',
            [
                'label' => __('Background Image', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
                'condition' => [
                    'layout_type' => 'layout_two'
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'left_area_content_section',
            [
                'label' => __('Left Area Content', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout_type' => 'layout_one'
                ]
            ]
        );

        $this->add_control(
            'left_area_title',
            [
                'label' => __(' Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Add Title', 'oxpins-addon'),
                'default' => __('Requirements', 'oxpins-addon')
            ]
        );

        $this->add_control(
            'left_area_summary',
            [
                'label' => __(' Summary', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Add Summary', 'oxpins-addon'),
                'default' => __('Default Summary Text', 'oxpins-addon')
            ]
        );

        $list_item = new \Elementor\Repeater();

        $list_item->add_control(
            'text',
            [
                'label' => __('Text', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Add Text', 'oxpins-addon'),
                'default' => __('Default Text', 'oxpins-addon'),
            ]
        );

        $list_item->add_control(
            'icon',
            [
                'label' => __('Check Icon', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fa fa-check',
                    'library' => 'custom-icon',
                ],
            ]
        );

        $this->add_control(
            'list_item',
            [
                'label' => __('List Item', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $list_item->get_controls(),
                'prevent_empty' => false,
                'title_field' => '{{{ text }}}',
            ]
        );

        $this->add_control(
            'call_text',
            [
                'label' => __('Call Text ', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Call Anytime', 'oxpins-addon'),
                'default' => __('Call Anytime', 'oxpins-addon'),
            ]
        );

        $this->add_control(
            'phone_number',
            [
                'label' => __('Phone Number ', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Add Phone Number', 'oxpins-addon'),
                'default' => __('+98 (000) - 9630', 'oxpins-addon'),
            ]
        );

        $this->add_control(
            'phone_url',
            [
                'label' => __('Phone Url', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Add Phone Url', 'oxpins-addon'),
                'default' => '#'
            ]
        );

        $this->add_control(
            'phone_icon',
            [
                'label' => __('Phone Icon', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'icon-chat',
                    'library' => 'custom-icon',
                ],
            ]
        );

        $this->add_control(
            'layout_one_image',
            [
                'label' => __('Image', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );
        $this->add_control(
            'left_area_bg',
            [
                'label' => __('Content Background', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $this->end_controls_section();


        //style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        oxpins_typo_and_color_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one', 'layout_two']);
        oxpins_typo_and_color_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline', ['layout_one', 'layout_two']);


        oxpins_typo_and_color_options($this, 'Left Area Title', '{{WRAPPER}} .become-volunteer-page__title', ['layout_one']);
        oxpins_typo_and_color_options($this, 'Left Area Summary', '{{WRAPPER}} .become-volunteer-page__text', ['layout_one']);
        oxpins_typo_and_color_options($this, 'Phone Text', '{{WRAPPER}} .become-volunteer__call-content span', ['layout_one']);
        oxpins_typo_and_color_options($this, 'Phone Number', '{{WRAPPER}} .become-volunteer__call-content p a', ['layout_one']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include oxpins_get_template('contact-form-one.php');
        include oxpins_get_template('contact-form-two.php');
    }
}
