<?php

namespace Layerdrops\Oxpins\Widgets;


class DonationDetails extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'oxpins-donation-details';
    }

    public function get_title()
    {
        return __('Donation Details', 'oxpins-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['oxpins-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Style', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'donation_thumbnail',
                'options' => [
                    'donation_thumbnail' => __('Post Thumbnail', 'oxpins-addon'),
                    'post_title' => __('Post Title', 'oxpins-addon'),
                    'donate_button' => __('Donate Button', 'oxpins-addon'),
                    'check_list' => __('Check List', 'oxpins-addon'),
                    'comments' => __('Comments', 'oxpins-addon'),
                    'donor_list' => __('Custom Donor List', 'oxpins-addon'),
                    'organize' => __('Sidebar - organize Info ', 'oxpins-addon'),
                ]
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'donate_button_content_section',
            [
                'label' => __('Content', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout_type' => 'donate_button'
                ]
            ]
        );


        $this->add_control(
            'raised_icon',
            [
                'label' => __('Icon', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'icon-solidarity',
                    'library' => 'custom-icon',
                ],
            ]
        );

        $this->add_control(
            'raised_text',
            [
                'label' => __(' Raised Text', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Raised	', 'oxpins-addon'),
                'label_block' => true,
            ]
        );


        $this->add_control(
            'goal_icon',
            [
                'label' => __('Goal Icon', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'icon-target-1',
                    'library' => 'custom-icon',
                ],
            ]
        );


        $this->add_control(
            'goal_text',
            [
                'label' => __(' Goal Text', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Goal', 'oxpins-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'background_image',
            [
                'label' => __('Add Background Image', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'donate_check_list',
            [
                'label' => __('Content', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout_type' => 'check_list'
                ]
            ]
        );

        $check_list = new \Elementor\Repeater();

        $check_list->add_control(
            'title',
            [
                'label' => __('Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Add title', 'oxpins-addon'),
                'default' => __('Nsectetur cing do not elit.', 'oxpins-addon'),
                'label_block' => true
            ]
        );


        $check_list->add_control(
            'icon',
            [
                'label' => __('Check Icon', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fa fa-check',
                    'library' => 'custom-icon',
                ],
            ]
        );

        $this->add_control(
            'check_list',
            [
                'label' => __('Check List', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $check_list->get_controls(),
                'prevent_empty' => false,
                'title_field' => '{{{ title }}}',
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'custom_donor_list',
            [
                'label' => __('Content', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout_type' => 'donor_list'
                ]
            ]
        );

        $this->add_control(
            'donation_list_title',
            [
                'label' => __('Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Recent donors ', 'oxpins-addon'),
                'label_block' => true,
            ]
        );

        $donor_list_item = new \Elementor\Repeater();


        $donor_list_item->add_control(
            'name',
            [
                'label' => __('Donor Name', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Kevin martin ', 'oxpins-addon'),
                'label_block' => true,
            ]
        );

        $donor_list_item->add_control(
            'amount',
            [
                'label' => __('Donation Amount', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('$25', 'oxpins-addon'),
                'label_block' => true,
            ]
        );

        $donor_list_item->add_control(
            'donor_image',
            [
                'label' => __('Donor Image ', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'donor_list_item',
            [
                'label' => __('Donor List', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $donor_list_item->get_controls(),
                'prevent_empty' => false,
                'title_field' => '{{{ name }}}',
            ]
        );

        $this->add_control(
            'donor_list_bg',
            [
                'label' => __('Background Image ', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'organizer_sidebar',
            [
                'label' => __('Content', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout_type' => 'organize'
                ]
            ]
        );


        $this->add_control(
            'organizer_bg',
            [
                'label' => __('Background Image ', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );

        $this->end_controls_section();


        //style layout one
        $this->start_controls_section(
            'style_options',
            [
                'label' => esc_html__('Style Options', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        oxpins_typo_and_color_options($this, 'Category', '{{WRAPPER}} .donation-details__date p', ['donation_thumbnail']);
        oxpins_typo_and_color_options($this, 'Title', '{{WRAPPER}} .donation-details__title', ['post_title']);
        oxpins_typo_and_color_options($this, 'Text', '{{WRAPPER}} .donation-details__donate-list li .text span', ['donate_button']);

        oxpins_typo_and_color_options($this, 'Check List', '{{WRAPPER}} .donation-details__summary-list li .text p', ['check_list']);

        oxpins_typo_and_color_options($this, 'Button', '{{WRAPPER}} button', ['donate_button']);
        oxpins_typo_and_color_options($this, 'Button Background', '{{WRAPPER}} button', ['donate_button'], 'background-color', false);

        oxpins_typo_and_color_options($this, 'Donor List Title', '{{WRAPPER}} h3', ['donor_list']);
        oxpins_typo_and_color_options($this, 'Name', '{{WRAPPER}} .donation-details__recent-donation-content p', ['donor_list']);
        oxpins_typo_and_color_options($this, 'Amount', '{{WRAPPER}} .donation-details__recent-donation-content span', ['donor_list']);

        oxpins_typo_and_color_options($this, 'Date', '{{WRAPPER}} .donation-details__organizer-date', ['organize']);
        oxpins_typo_and_color_options($this, 'Organizer Title', '{{WRAPPER}} .donation-details__organizer-title', ['organize']);
        oxpins_typo_and_color_options($this, 'Organizer Name', '{{WRAPPER}} .donation-details__organizer-name', ['organize']);
        oxpins_typo_and_color_options($this, 'Category & Location', '{{WRAPPER}} .donation-details__organizer-list li .text p', ['organize']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include oxpins_get_template('donation-thumbnail.php');
        include oxpins_get_template('donation-title.php');
        include oxpins_get_template('donate-button-one.php');
        include oxpins_get_template('donate-checklist-one.php');
        include oxpins_get_template('donation-comment-one.php');
        include oxpins_get_template('custom-donor-list.php');
        include oxpins_get_template('donation-organizer-sidebar.php');
    }
}
