<?php

namespace Layerdrops\Oxpins\Widgets;


class DonationForm extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'oxpins-donation-form';
    }

    public function get_title()
    {
        return __('Donation Form', 'oxpins-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['oxpins-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'oxpins-addon'),
                ]
            ]
        );


        $this->end_controls_section();


        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Select Forms', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'sec_title',
            [
                'label' => __('Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Enter Your Donation Title', 'oxpins-addon'),
            ]
        );

        $this->add_control(
            'select_give_form',
            [
                'label'       => esc_html__('Select Your Donation Form', 'oxpins-addon'),
                'label_block' => true,
                'type'        => \Elementor\Controls_Manager::SELECT,
                'options'     => oxpins_post_query('give_forms'),
            ]
        );

        $this->add_control(
            'post_word_count',
            [
                'label' => __('Word Count In Excerpt', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['count'],
                'range' => [
                    'count' => [
                        'min' => 1,
                        'max' => 200,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'count',
                    'size' => 11,
                ],
            ]
        );

        $this->add_control(
            'progress_bar_bg',
            [
                'label' => __('Progress Bar Background', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'organizer_bg',
            [
                'label' => __('Organizer Background', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );

        $this->end_controls_section();

        //style layout one
        $this->start_controls_section(
            'style_options',
            [
                'label' => esc_html__('Style Options', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        oxpins_typo_and_color_options($this, 'Section Title', '{{WRAPPER}} .donate-now__title', ['layout_one']);
        oxpins_typo_and_color_options($this, 'Give Form Title ', '{{WRAPPER}} .causes-one__title ', ['layout_one', 'layout_two']);
        oxpins_typo_and_color_options($this, 'Give Form Summary ', '{{WRAPPER}} .causes-one__text ', ['layout_one', 'layout_two']);
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include oxpins_get_template('donation-form-one.php');
    }
}
