<?php

namespace Layerdrops\Oxpins\Widgets;


class Event extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'oxpins-event';
    }

    public function get_title()
    {
        return __('Event', 'oxpins-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['oxpins-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'oxpins-addon'),
                    'layout_two' => __('Layout Two', 'oxpins-addon'),
                    'layout_three' => __('Layout Three', 'oxpins-addon'),
                    'layout_four' => __('Layout Four', 'oxpins-addon'),
                ]
            ]
        );


        $this->add_control(
            'title',
            [
                'label' => __('Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Add Title', 'oxpins-addon'),
                'default' => __('Default Title', 'oxpins-addon'),
                'condition'   => [
                    'layout_type' => ['layout_one', 'layout_two']
                ]
            ]
        );

        $this->add_control(
            'sub_title',
            [
                'label' => __('Sub Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Add Sub Title', 'oxpins-addon'),
                'default' => __('Default Sub Title', 'oxpins-addon'),
                'condition'   => [
                    'layout_type' => ['layout_one', 'layout_two']
                ]
            ]
        );

        $this->add_control(
            'summary',
            [
                'label' => __('Summary', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Summary', 'oxpins-addon'),
                'default' => __('Default Summary Text', 'oxpins-addon'),
                'condition'   => [
                    'layout_type' => ['layout_one', 'layout_two']
                ]
            ]
        );

        $this->add_control(
            'button_label',
            [
                'label' => __('Button Text', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Discover More', 'oxpins-addon'),
                'label_block' => true,
                'condition'   => [
                    'layout_type' => ['layout_one', 'layout_two']
                ]
            ]
        );

        $this->add_control(
            'button_url',
            [
                'label' => __('Button Url', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'oxpins-addon'),
                'show_external' => false,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'show_label' => false,
                'condition'   => [
                    'layout_type' => ['layout_one', 'layout_two']
                ]
            ]
        );

        $this->add_control(
            'bg_image',
            [
                'label' => __('Background Image', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'condition'   => [
                    'layout_type' =>  'layout_two'
                ]
            ]
        );

        $this->add_control(
            'shape',
            [
                'label' => __('Shape', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'condition'   => [
                    'layout_type' => ['layout_one', 'layout_two']
                ]
            ]
        );

        $this->add_control(
            'shape_two',
            [
                'label' => __('Shape Two', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'condition'   => [
                    'layout_type' =>  'layout_two'
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Post Options', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'query_order',
            [
                'label' => __('Select Order', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'DESC',
                'options' => [
                    'DESC' => __('DESC', 'oxpins-addon'),
                    'ASC' => __('ASC', 'oxpins-addon'),
                ]
            ]
        );

        $this->add_control(
            'post_count',
            [
                'label' => __('Number Of Posts', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['count'],
                'range' => [
                    'count' => [
                        'min' => 0,
                        'max' => 15,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'count',
                    'size' => 6,
                ],
            ]
        );

        $this->add_control(
            'pagination_status',
            [
                'label' => __('Enable Pagination?', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'oxpins-addon'),
                'label_off' => __('No', 'oxpins-addon'),
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => [
                    'layout_type' => 'layout_three'
                ]

            ]
        );

        $this->add_control(
            'event_type',
            [
                'label' => esc_html__('Event Type', 'oxpins'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'all_event',
                'options' => [
                    'all_event'  => esc_html__('All Event', 'oxpins'),
                    'upcoming_event' => esc_html__('Upcoming Event', 'oxpins'),
                ],
            ]
        );

        $this->end_controls_section();

        //style
        $this->start_controls_section(
            'style_options',
            [
                'label' => esc_html__('Style Options', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        oxpins_typo_and_color_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one', 'layout_two']);
        oxpins_typo_and_color_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline', ['layout_one', 'layout_two']);
        oxpins_typo_and_color_options($this, 'Summary Text', '{{WRAPPER}} .events-one__text-1, {{WRAPPER}} .events-two__text', ['layout_one', 'layout_two']);

        oxpins_typo_and_color_options($this, 'Title', '{{WRAPPER}} .events-one__title a,{{WRAPPER}} .events-two__title a', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
        oxpins_typo_and_color_options($this, 'Meta', '{{WRAPPER}} .events-one__meta li,{{WRAPPER}} .events-two__meta > li', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
        oxpins_typo_and_color_options($this, 'Date', '{{WRAPPER}} .events-one__date p,{{WRAPPER}} .events-two__date p', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);

        oxpins_typo_and_color_options($this, 'Button', '{{WRAPPER}} .thm-btn,{{WRAPPER}} .events-two__btn', ['layout_one', 'layout_two']);
        oxpins_typo_and_color_options($this, 'Button Background', '{{WRAPPER}} .thm-btn,{{WRAPPER}} .events-two__btn', ['layout_one', 'layout_two'], 'background-color', false);


        $this->end_controls_section();

        // load carousel options
        oxpins_get_elementor_carousel_options($this, ['layout_one', 'layout_four']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include oxpins_get_template('event-one.php');
        include oxpins_get_template('event-two.php');
        include oxpins_get_template('event-three.php');
        include oxpins_get_template('event-four.php');
    }
}
