<?php

namespace Layerdrops\Oxpins\Widgets;


class FancyBox extends \Elementor\Widget_Base
{
	public function get_name()
	{
		return 'oxpins-fancy-box';
	}

	public function get_title()
	{
		return __('Fancy Box', 'oxpins-addon');
	}

	public function get_icon()
	{
		return 'eicon-cogs';
	}

	public function get_categories()
	{
		return ['oxpins-category'];
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'oxpins-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'oxpins-addon'),
					'layout_two' => __('Layout Two', 'oxpins-addon'),
					'layout_three' => __('Layout Three', 'oxpins-addon'),
					'layout_four' => __('Layout Four', 'oxpins-addon'),
				]
			]
		);


		$this->end_controls_section();

		$this->start_controls_section(
			'content_section',
			[
				'label' => __('Content', 'oxpins-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$layout_one_item = new \Elementor\Repeater();

		$layout_one_item->add_control(
			'icon',
			[
				'label' => __('Icon', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'icon-help',
					'library' => 'custom-icon',
				],
			]
		);

		$layout_one_item->add_control(
			'title',
			[
				'label' => __('Title', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => wp_kses(__('Join us & become <br> a volunteer', 'oxpins-addon'), 'oxpins_allowed_tags'),
				'label_block' => true,
			]
		);

		$layout_one_item->add_control(
			'summary',
			[
				'label' => __('Summary', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => __('Summary Text', 'oxpins-addon'),
				'label_block' => true,
			]
		);


		$layout_one_item->add_control(
			'list',
			[
				'label' => __('Check List', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::CODE,
				'default' => wp_kses(__('<li><div class="icon"><span class="fa fa-check"></span></div><div class="text"><p>Sed et nulla a nunc finibus eleifend.</p></div></li>', 'oxpins-addon'), 'oxpins_allowed_tags'),
				'label_block' => true,
			]
		);


		$layout_one_item->add_control(
			'button_label',
			[
				'label' => __('Button Text', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __(' View details', 'oxpins-addon'),
				'label_block' => true,
			]
		);

		$layout_one_item->add_control(
			'button_url',
			[
				'label' => __('Url', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __('#', 'oxpins-addon'),
				'show_external' => false,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
			]
		);

		$layout_one_item->add_control(
			'background',
			[
				'label' => __('Add Background Image', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);

		$this->add_control(
			'fancy_box_items',
			[
				'label' => __('Fancy Boxes', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $layout_one_item->get_controls(),
				'prevent_empty' => false,
				'condition' => [
					'layout_type' => 'layout_one'
				],
				'title_field' => '{{{ title }}}',
			]
		);


		$layout_two_item = new \Elementor\Repeater();

		$layout_two_item->add_control(
			'title',
			[
				'label' => __('Title', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => __('Healthy Food', 'oxpins-addon'),
				'label_block' => true,
			]
		);

		$layout_two_item->add_control(
			'url',
			[
				'label' => __('Url', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __('#', 'oxpins-addon'),
				'show_external' => false,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
			]
		);

		$layout_two_item->add_control(
			'sub_title',
			[
				'label' => __('Sub Title', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Donate to', 'oxpins-addon'),
				'label_block' => true,
			]
		);

		$layout_two_item->add_control(
			'icon',
			[
				'label' => __('Icon', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'icon-apple',
					'library' => 'custom-icon',
				],
			]
		);

		$layout_two_item->add_control(
			'background',
			[
				'label' => __('Add Background Image', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);

		$this->add_control(
			'fancy_box_two_items',
			[
				'label' => __('Fancy Boxes', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $layout_two_item->get_controls(),
				'prevent_empty' => false,
				'condition' => [
					'layout_type' => 'layout_two'
				],
				'default' => [
					[
						'title' => __('Healthy Food', 'oxpins-addon'),
					],
				],
				'title_field' => '{{{ title }}}',
			]
		);


		$layout_three_item = new \Elementor\Repeater();

		$layout_three_item->add_control(
			'title',
			[
				'label' => __('Title', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Partner', 'oxpins-addon'),
				'label_block' => true,
			]
		);


		$layout_three_item->add_control(
			'read_more_text',
			[
				'label' => __('Read More Text', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Join us', 'oxpins-addon'),
				'label_block' => true,
			]
		);

		$layout_three_item->add_control(
			'url',
			[
				'label' => __('Url', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __('#', 'oxpins-addon'),
				'show_external' => false,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
			]
		);

		$layout_three_item->add_control(
			'image',
			[
				'label' => __('Add Image', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'fancy_box_three_items',
			[
				'label' => __('Fancy Boxes', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $layout_three_item->get_controls(),
				'prevent_empty' => false,
				'condition' => [
					'layout_type' => 'layout_three'
				],
				'default' => [
					[
						'title' => __('Partner', 'oxpins-addon'),
					],
				],
				'title_field' => '{{{ title }}}',
			]
		);


		$layout_four_item = new \Elementor\Repeater();

		$layout_four_item->add_control(
			'title',
			[
				'label' => __('Title', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Homepage 01', 'oxpins-addon'),
				'label_block' => true,
			]
		);

		$layout_four_item->add_control(
			'button_one_label',
			[
				'label' => __('Button One Text', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Multi Page', 'oxpins-addon'),
				'label_block' => true,
			]
		);

		$layout_four_item->add_control(
			'button_one_url',
			[
				'label' => __('Button One Url', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __('#', 'oxpins-addon'),
				'show_external' => false,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
				'show_label' => false,
			]
		);

		$layout_four_item->add_control(
			'button_two_label',
			[
				'label' => __('Button One Text', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('One Page', 'oxpins-addon'),
				'label_block' => true,
			]
		);

		$layout_four_item->add_control(
			'button_two_url',
			[
				'label' => __('Button Two Url', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __('#', 'oxpins-addon'),
				'show_external' => false,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
				'show_label' => false,
			]
		);

		$layout_four_item->add_control(
			'image',
			[
				'label' => __('Image', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);

		$this->add_control(
			'layout_four_item',
			[
				'label' => __('Fancy Boxes', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $layout_four_item->get_controls(),
				'prevent_empty' => false,
				'condition' => [
					'layout_type' => 'layout_four'
				],
				'title_field' => '{{{ title }}}',
			]
		);

		$this->end_controls_section();

		//style layout one
		$this->start_controls_section(
			'general_style_layout_one',
			[
				'label' => esc_html__('Style Options', 'oxpins-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		oxpins_typo_and_color_options($this, 'Fancy Box Title', '{{WRAPPER}} .feature-two__title a, {{WRAPPER}} .feature-one__top-title a,{{WRAPPER}} .feature-three__title', ['layout_one', 'layout_two', 'layout_three']);
		oxpins_typo_and_color_options($this, 'Fancy Box Sub Title', '{{WRAPPER}} .feature-two__tagline', ['layout_two']);
		oxpins_typo_and_color_options($this, 'Fancy Box Summary', '{{WRAPPER}} .feature-one__text', ['layout_one']);
		oxpins_typo_and_color_options($this, 'Fancy Box Button', '{{WRAPPER}} .donate-btn,{{WRAPPER}} .thm-btn', ['layout_one']);
		oxpins_typo_and_color_options($this, 'Fancy Box Button Background', '{{WRAPPER}} .donate-btn,{{WRAPPER}} .feature-one__btn:before', ['layout_one'], 'background-color', false);

		oxpins_typo_and_color_options($this, 'Read More Text', '{{WRAPPER}} .feature-three__btn a', ['layout_three']);

		oxpins_typo_and_color_options($this, 'Title', '{{WRAPPER}} .home-showcase__title', ['layout_four']);
		oxpins_typo_and_color_options($this, 'Button', '{{WRAPPER}} .thm-btn', ['layout_four']);
		oxpins_typo_and_color_options($this, 'Button Background', '{{WRAPPER}} .thm-btn', ['layout_four'], 'background-color', false);

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include oxpins_get_template('fancy-box-one.php');
		include oxpins_get_template('fancy-box-two.php');
		include oxpins_get_template('fancy-box-three.php');
		include oxpins_get_template('fancy-box-four.php');
	}
}
