<?php

namespace Layerdrops\Oxpins\Widgets;


class Faq extends \Elementor\Widget_Base
{
	public function get_name()
	{
		return 'oxpins-faq';
	}

	public function get_title()
	{
		return __('FAQ', 'oxpins-addon');
	}

	public function get_icon()
	{
		return 'eicon-cogs';
	}

	public function get_categories()
	{
		return ['oxpins-category'];
	}

	protected function register_controls()
	{

		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'oxpins-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'oxpins-addon'),
					'layout_two' => __('Layout Two', 'oxpins-addon'),
					'layout_three' => __('Layout Three', 'oxpins-addon'),
				]
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'content_section',
			[
				'label' => __('Content', 'oxpins-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'layout_type' => ['layout_one', 'layout_two']
				]
			]
		);


		$this->add_control(
			'sec_title',
			[
				'label' => __('Section Title', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add title', 'oxpins-addon'),
				'default' => __('Default title', 'oxpins-addon'),
			]
		);

		$this->add_control(
			'sec_sub_title',
			[
				'label' => __('Section Sub Title', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => __('Sub sub title', 'oxpins-addon'),
			]
		);

		$this->add_control(
			'summary',
			[
				'label' => __('Default Summary', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => __('Default Summary', 'oxpins-addon'),
			]
		);

		$this->add_control(
			'button_label',
			[
				'label' => __('Button Text', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Learn how to get help', 'oxpins-addon'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'button_url',
			[
				'label' => __('Button Url', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __('#', 'oxpins-addon'),
				'show_external' => false,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
				'show_label' => false,
			]
		);

		$faq = new \Elementor\Repeater();

		$faq->add_control(
			'question',
			[
				'label' => __('Question', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __('Add Question', 'oxpins-addon'),
				'default' => __('Default Question', 'oxpins-addon'),
				'label_block' => true,
			]
		);
		$faq->add_control(
			'answer',
			[
				'label' => __('Answer', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add Answer', 'oxpins-addon'),
				'default' => __('Default Answer', 'oxpins-addon'),
				'label_block' => true,
			]
		);

		$faq->add_control(
			'active_status',
			[
				'label' => __('Is active?', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __('Yes', 'oxpins-addon'),
				'label_off' => __('No', 'oxpins-addon'),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'faq_lists',
			[
				'label' => __('FAQ', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $faq->get_controls(),
				'prevent_empty' => false,
				'title_field' => '{{{ question }}}',
			]
		);

		$this->add_control(
			'bg_image',
			[
				'label' => __('Add Background Image', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);


		$this->add_control(
			'bg_shape',
			[
				'label' => __('Add Background Shape', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'layout_three_content_section',
			[
				'label' => __('Content', 'oxpins-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'layout_type' => 'layout_three'
				]
			]
		);
		$layout_three_faq = new \Elementor\Repeater();


		$layout_three_faq->add_control(
			'question',
			[
				'label' => __('Question', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __('Add Question', 'oxpins-addon'),
				'default' => __('Default Question', 'oxpins-addon'),
				'label_block' => true,
			]
		);
		$layout_three_faq->add_control(
			'answer',
			[
				'label' => __('Answer', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add Answer', 'oxpins-addon'),
				'default' => __('Default Answer', 'oxpins-addon'),
				'label_block' => true,
			]
		);

		$layout_three_faq->add_control(
			'active_status',
			[
				'label' => __('Is active?', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __('Yes', 'oxpins-addon'),
				'label_off' => __('No', 'oxpins-addon'),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'layout_three_faq',
			[
				'label' => __('FAQ', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $layout_three_faq->get_controls(),
				'prevent_empty' => false,
				'title_field' => '{{{ question }}}',
			]
		);


		$this->end_controls_section();

		//style
		$this->start_controls_section(
			'style_options',
			[
				'label' => esc_html__('Style Options', 'oxpins-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		oxpins_typo_and_color_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one', 'layout_two']);
		oxpins_typo_and_color_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline', ['layout_one', 'layout_two']);
		oxpins_typo_and_color_options($this, 'Summary', '{{WRAPPER}} .faq-one__text-1', ['layout_one', 'layout_two']);

		oxpins_typo_and_color_options($this, 'Question Color', '{{WRAPPER}} .faq-one-accrodion .accrodion-title h4', ['layout_one', 'layout_two', 'layout_three']);
		oxpins_typo_and_color_options($this, 'Answer Color', '{{WRAPPER}} .faq-one-accrodion .accrodion-content p', ['layout_one', 'layout_two', 'layout_three']);

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include oxpins_get_template('faq-one.php');
		include oxpins_get_template('faq-two.php');
		include oxpins_get_template('faq-three.php');
	}
}
