<?php

namespace Layerdrops\Oxpins\Widgets;


class FooterAbout extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'footer-about';
    }

    public function get_title()
    {
        return __('Footer About', 'oxpins-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['oxpins-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'oxpins-addon'),
                ]
            ]
        );


        $this->end_controls_section();


        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
            'logo',
            [
                'label' => __('Logo', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'logo_dimension',
            [
                'label' => __('Logo Dimension', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::IMAGE_DIMENSIONS,
                'description' => __('Set Custom Logo Size.', 'oxpins-addon'),
                'default' => [
                    'width' => '150',
                    'height' => '50',
                ],
            ]
        );

        $this->add_control(
            'text',
            [
                'label' => __('About Text', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Add About Text', 'oxpins-addon'),
                'default' => __('Default Text', 'oxpins-addon'),
            ]
        );

        $this->add_control(
            'button_label',
            [
                'label' => __('Button Text', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Donate Now', 'oxpins-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'button_url',
            [
                'label' => __('Button Url', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'oxpins-addon'),
                'show_external' => false,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'show_label' => false,
            ]
        );


        $this->end_controls_section();

        //style layout one
        $this->start_controls_section(
            'style_options',
            [
                'label' => esc_html__('Style Options', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        oxpins_typo_and_color_options($this, 'About Text', '{{WRAPPER}} .footer-widget__about-text', ['layout_one']);
        oxpins_typo_and_color_options($this, 'Button', '{{WRAPPER}} .footer-widget__btn a', ['layout_one']);
        oxpins_typo_and_color_options($this, 'Button Background', '{{WRAPPER}} .footer-widget__btn a', ['layout_one'], 'background-color', false);
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include oxpins_get_template('footer-about.php');
    }
}
